/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.authorization;

import ch.systemsx.cisd.openbis.generic.server.authorization.SpaceOwnerKind;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IAuthorizationDAOFactory;
import ch.systemsx.cisd.openbis.generic.shared.authorization.IAuthorizationConfig;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataSetAccessPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.DeletionPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ExperimentAccessPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ExperimentPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.GridCustomColumnPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.GridCustomFilterPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.MetaprojectPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.PermId;
import ch.systemsx.cisd.openbis.generic.shared.dto.ProjectPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.QueryPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SampleAccessPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SamplePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SpacePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ProjectIdentifier;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

public interface IAuthorizationDataProvider {
    public IAuthorizationDAOFactory getDaoFactory();

    public IAuthorizationConfig getAuthorizationConfig();

    public List<SpacePE> listSpaces();

    public SpacePE tryGetSpace(String var1);

    public ExperimentPE tryGetExperimentByTechId(TechId var1);

    public Map<TechId, ExperimentPE> tryGetExperimentsByTechIds(Collection<TechId> var1);

    public ExperimentPE tryGetExperimentByPermId(String var1);

    public SamplePE tryGetSampleByPermId(String var1);

    public SamplePE tryGetSampleBySpaceAndCode(SpacePE var1, String var2);

    public SamplePE tryGetSampleByProjectAndCode(ProjectPE var1, String var2);

    public Map<TechId, SamplePE> tryGetSamplesByTechIds(Collection<TechId> var1);

    public Map<TechId, DataPE> tryGetDataSetsByTechIds(Collection<TechId> var1);

    public ProjectPE tryGetProjectForDataSet(String var1);

    public ProjectPE tryGetProjectByPermId(PermId var1);

    public ProjectPE tryGetProjectByTechId(TechId var1);

    public Map<TechId, ProjectPE> tryGetProjectsByTechIds(Collection<TechId> var1);

    public ProjectPE tryGetProjectByIdentifier(ProjectIdentifier var1);

    public Set<DataSetAccessPE> getDatasetCollectionAccessDataByTechIds(List<TechId> var1, boolean var2);

    public Set<DataSetAccessPE> getDatasetCollectionAccessDataByCodes(List<String> var1);

    public Set<SampleAccessPE> getSampleCollectionAccessDataByTechIds(List<TechId> var1, boolean var2);

    public Set<SampleAccessPE> getSampleCollectionAccessDataByPermIds(List<PermId> var1);

    public Set<ExperimentAccessPE> getExperimentCollectionAccessData(List<TechId> var1, boolean var2);

    public Set<DataSetAccessPE> getDeletedDatasetCollectionAccessData(List<TechId> var1);

    public Set<SampleAccessPE> getDeletedSampleCollectionAccessData(List<TechId> var1);

    public Set<ExperimentAccessPE> getDeletedExperimentCollectionAccessData(List<TechId> var1);

    public SpacePE tryGetSpace(SpaceOwnerKind var1, TechId var2);

    public Set<SpacePE> getDistinctSpacesByEntityIds(SpaceOwnerKind var1, List<TechId> var2);

    public SamplePE getSample(TechId var1);

    public GridCustomFilterPE getGridCustomFilter(TechId var1);

    public GridCustomColumnPE getGridCustomColumn(TechId var1);

    public QueryPE getQuery(TechId var1);

    public List<DeletionPE> getDeletions(List<TechId> var1);

    public MetaprojectPE getMetaproject(TechId var1);
}

