/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.authorization;

import ch.rinn.restrictions.Private;
import ch.systemsx.cisd.common.exceptions.Status;
import ch.systemsx.cisd.openbis.generic.server.authorization.Argument;
import ch.systemsx.cisd.openbis.generic.server.authorization.AuthorizationDataProvider;
import ch.systemsx.cisd.openbis.generic.server.authorization.IAuthorizationDataProvider;
import ch.systemsx.cisd.openbis.generic.server.authorization.IPredicateFactory;
import ch.systemsx.cisd.openbis.generic.server.authorization.RoleWithIdentifier;
import ch.systemsx.cisd.openbis.generic.server.authorization.annotation.ShouldFlattenCollections;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.ArrayPredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.CollectionPredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.IPredicate;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IAuthorizationDAOFactory;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import java.util.List;

public final class PredicateExecutor {
    private IPredicateFactory predicateFactory;
    private IAuthorizationDataProvider authorizationDataProvider;

    final void setPredicateFactory(IPredicateFactory predicateProvider) {
        this.predicateFactory = predicateProvider;
    }

    final void setDAOFactory(IAuthorizationDAOFactory daoFactory) {
        this.authorizationDataProvider = new AuthorizationDataProvider(daoFactory);
    }

    final void setAuthorizationDataProvider(IAuthorizationDataProvider authorizationDataProvider) {
        this.authorizationDataProvider = authorizationDataProvider;
    }

    private final <T> IPredicate<T> createPredicate(Class<? extends IPredicate<?>> predicateClass) {
        assert (this.predicateFactory != null) : "Unspecified predicate factory";
        Class<? extends IPredicate<?>> predicateClassT = predicateClass;
        IPredicate predicate = this.predicateFactory.createPredicateForClass(predicateClassT);
        assert (predicate != null) : "Predicate factory should not return a null predicate";
        return predicate;
    }

    private static final <T> T[] castToArray(T argumentValue) {
        return (Object[])argumentValue;
    }

    private static final <T> List<T> castToList(T argumentValue) {
        return (List)argumentValue;
    }

    public final <T> Status evaluate(PersonPE person, List<RoleWithIdentifier> allowedRoles, Argument<T> argument) {
        assert (person != null) : "Person unspecified";
        assert (allowedRoles != null) : "Allowed roles not specified";
        assert (argument != null) : "Argument not specified";
        T argumentValue = argument.tryGetArgument();
        Class<IPredicate<?>> predicateClass = argument.getPredicateCandidate().guardClass();
        Class<T> argumentType = argument.getType();
        ShouldFlattenCollections flattenAnnotation = predicateClass.getAnnotation(ShouldFlattenCollections.class);
        boolean shouldFlattenCollections = null == flattenAnnotation ? true : flattenAnnotation.value();
        return this.evaluate(person, allowedRoles, argumentValue, predicateClass, argumentType, shouldFlattenCollections);
    }

    @Private
    final <T> Status evaluate(PersonPE person, List<RoleWithIdentifier> allowedRoles, T argumentValue, Class<? extends IPredicate<?>> predicateClass, Class<T> argumentType, boolean shouldFlattenCollections) {
        assert (this.authorizationDataProvider != null) : "Authorization data provider not set";
        IPredicate<T> predicate = this.createPredicate(predicateClass);
        if (List.class.isAssignableFrom(argumentType) && shouldFlattenCollections) {
            CollectionPredicate<List<T>> collectionPredicate = new CollectionPredicate<List<T>>(predicate);
            collectionPredicate.init(this.authorizationDataProvider);
            List<T> list = PredicateExecutor.castToList(argumentValue);
            try {
                return collectionPredicate.evaluate(person, allowedRoles, list);
            }
            catch (ClassCastException e) {
                throw new IllegalArgumentException(String.format("Given predicate class '%s' and list type '%s' are not compatible.", predicateClass.getName(), list.get(0).getClass().getName()));
            }
        }
        if (argumentType.isArray() && shouldFlattenCollections) {
            ArrayPredicate<T[]> arrayPredicate = new ArrayPredicate<T[]>(predicate);
            arrayPredicate.init(this.authorizationDataProvider);
            try {
                return arrayPredicate.evaluate(person, allowedRoles, PredicateExecutor.castToArray(argumentValue));
            }
            catch (ClassCastException e) {
                throw new IllegalArgumentException(String.format("Given predicate class '%s' and array type '%s' are not compatible.", predicateClass.getName(), argumentType.getComponentType().getName()));
            }
        }
        predicate.init(this.authorizationDataProvider);
        try {
            return predicate.evaluate(person, allowedRoles, argumentValue);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException(String.format("Given predicate class '%s' and argument type '%s' are not compatible.", predicateClass.getName(), argumentType.getName()));
        }
    }
}

