/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.authorization;

import ch.rinn.restrictions.Private;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.RoleWithHierarchy;
import ch.systemsx.cisd.openbis.generic.shared.dto.ProjectPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.RoleAssignmentPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SpacePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.IdentifierHelper;

public final class RoleWithIdentifier {
    RoleWithHierarchy role;
    private final SpacePE spaceOrNull;
    private final ProjectPE projectOrNull;

    @Private
    RoleWithIdentifier(RoleWithHierarchy.RoleLevel roleLevel, RoleWithHierarchy.RoleCode roleName, SpacePE spaceOrNull, ProjectPE projectOrNull) {
        this.role = RoleWithHierarchy.valueOf(roleLevel, roleName);
        if (RoleWithHierarchy.RoleLevel.SPACE.equals((Object)roleLevel)) {
            assert (spaceOrNull != null) : "Unspecified space";
        } else assert (spaceOrNull == null);
        this.spaceOrNull = spaceOrNull;
        if (RoleWithHierarchy.RoleLevel.PROJECT.equals((Object)roleLevel)) {
            assert (projectOrNull != null) : "Unspecified project";
        } else assert (projectOrNull == null);
        this.projectOrNull = projectOrNull;
    }

    public final SpacePE getAssignedSpace() {
        assert (this.spaceOrNull != null);
        return this.spaceOrNull;
    }

    public final ProjectPE getAssignedProject() {
        assert (this.projectOrNull != null);
        return this.projectOrNull;
    }

    public static final RoleWithIdentifier createRole(RoleAssignmentPE roleAssignment) {
        assert (roleAssignment != null) : "Unspecified role assignment";
        RoleWithHierarchy.RoleLevel roleLevel = roleAssignment.getRoleLevel();
        RoleWithHierarchy.RoleCode roleName = roleAssignment.getRole();
        SpacePE space = roleAssignment.getSpace();
        ProjectPE project = roleAssignment.getProject();
        return new RoleWithIdentifier(roleLevel, roleName, space, project);
    }

    public final String toString() {
        StringBuilder builder = new StringBuilder(super.toString());
        builder.append("<").append(this.createOwnerDescription()).append(">");
        return builder.toString();
    }

    private String createOwnerDescription() {
        if (this.projectOrNull != null) {
            return IdentifierHelper.createProjectIdentifier(this.projectOrNull).toString();
        }
        if (this.spaceOrNull != null) {
            return IdentifierHelper.createGroupIdentifier(this.spaceOrNull).toString();
        }
        return RoleWithHierarchy.RoleLevel.INSTANCE.name();
    }

    public RoleWithHierarchy.RoleLevel getRoleLevel() {
        return this.role.getRoleLevel();
    }

    public RoleWithHierarchy.RoleCode getRoleName() {
        return this.role.getRoleCode();
    }

    public RoleWithHierarchy getRole() {
        return this.role;
    }
}

