/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.authorization.predicate;

import ch.systemsx.cisd.common.exceptions.Status;
import ch.systemsx.cisd.openbis.generic.server.authorization.IAuthorizationDataProvider;
import ch.systemsx.cisd.openbis.generic.server.authorization.RoleWithIdentifier;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.AbstractDatabaseInstancePredicate;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.RoleWithHierarchy;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SpacePE;
import ch.systemsx.cisd.openbis.generic.shared.util.SpaceCodeHelper;
import java.util.List;

public abstract class AbstractSpacePredicate<T>
extends AbstractDatabaseInstancePredicate<T> {
    protected List<SpacePE> spaces;
    protected boolean okForNonExistentSpaces;

    protected AbstractSpacePredicate() {
        this(false);
    }

    protected AbstractSpacePredicate(boolean okForNonExistentSpaces) {
        this.okForNonExistentSpaces = okForNonExistentSpaces;
    }

    @Override
    public void init(IAuthorizationDataProvider provider) {
        super.init(provider);
        this.spaces = provider.listSpaces();
    }

    protected Status evaluate(List<RoleWithIdentifier> allowedRoles, PersonPE person, String spaceCodeOrNull) {
        if (this.tryFindSpace(spaceCodeOrNull) == null) {
            if (this.okForNonExistentSpaces) {
                return Status.OK;
            }
            return this.createError(person);
        }
        boolean matching = this.isMatching(allowedRoles, spaceCodeOrNull);
        if (matching) {
            return Status.OK;
        }
        return this.createError(person);
    }

    @Override
    protected Status evaluate(PersonPE person, List<RoleWithIdentifier> allowedRoles, long spaceTechId) {
        SpacePE space = this.tryFindSpace(spaceTechId);
        if (space == null) {
            if (this.okForNonExistentSpaces) {
                return Status.OK;
            }
            return this.createError(person);
        }
        boolean matching = this.isMatching(allowedRoles, spaceTechId);
        if (matching) {
            return Status.OK;
        }
        return this.createError(person);
    }

    private Status createError(PersonPE person) {
        return Status.createError((String)String.format("User '%s' does not have enough privileges.", person.getUserId()));
    }

    private SpacePE tryFindSpace(String spaceCode) {
        for (SpacePE space : this.spaces) {
            if (!space.getCode().equals(spaceCode)) continue;
            return space;
        }
        return null;
    }

    private SpacePE tryFindSpace(long spaceTechId) {
        for (SpacePE space : this.spaces) {
            if (!this.equalIdentifier(space, spaceTechId)) continue;
            return space;
        }
        return null;
    }

    private boolean isMatching(List<RoleWithIdentifier> allowedRoles, String spaceCodeOrNull) {
        for (RoleWithIdentifier role : allowedRoles) {
            RoleWithHierarchy.RoleLevel roleLevel = role.getRoleLevel();
            if (roleLevel.equals((Object)RoleWithHierarchy.RoleLevel.SPACE) && role.getAssignedSpace().getCode().equals(spaceCodeOrNull)) {
                return true;
            }
            if (!roleLevel.equals((Object)RoleWithHierarchy.RoleLevel.INSTANCE)) continue;
            return true;
        }
        return false;
    }

    private boolean isMatching(List<RoleWithIdentifier> allowedRoles, long spaceTechId) {
        for (RoleWithIdentifier role : allowedRoles) {
            RoleWithHierarchy.RoleLevel roleLevel = role.getRoleLevel();
            if (roleLevel.equals((Object)RoleWithHierarchy.RoleLevel.SPACE) && this.equalIdentifier(role.getAssignedSpace(), spaceTechId)) {
                return true;
            }
            if (!roleLevel.equals((Object)RoleWithHierarchy.RoleLevel.INSTANCE)) continue;
            return true;
        }
        return false;
    }

    private boolean equalIdentifier(SpacePE space, long spaceTechId) {
        return space.getId() == spaceTechId;
    }

    protected Status evaluateSpace(PersonPE person, List<RoleWithIdentifier> allowedRoles, SpacePE spaceOrNull) {
        if (spaceOrNull == null) {
            return Status.createError((String)String.format("User '%s' does not have enough privileges.", person.getUserId()));
        }
        String spaceCode = SpaceCodeHelper.getSpaceCode(person, spaceOrNull);
        return this.evaluate(allowedRoles, person, spaceCode);
    }
}

