/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.authorization.predicate;

import ch.systemsx.cisd.common.exceptions.Status;
import ch.systemsx.cisd.openbis.generic.server.authorization.RoleWithIdentifier;
import ch.systemsx.cisd.openbis.generic.server.authorization.SpaceOwnerKind;
import ch.systemsx.cisd.openbis.generic.server.authorization.annotation.ShouldFlattenCollections;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.AbstractSpacePredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.project.IProjectAuthorization;
import ch.systemsx.cisd.openbis.generic.server.authorization.project.ProjectAuthorizationBuilder;
import ch.systemsx.cisd.openbis.generic.server.authorization.project.provider.project.ProjectsProviderFromExperimentTechIdCollection;
import ch.systemsx.cisd.openbis.generic.server.authorization.project.provider.project.ProjectsProviderFromProjectTechIdCollection;
import ch.systemsx.cisd.openbis.generic.server.authorization.project.provider.role.RolesProviderFromRolesWithIdentifier;
import ch.systemsx.cisd.openbis.generic.server.authorization.project.provider.user.UserProviderFromPersonPE;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SpacePE;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

@ShouldFlattenCollections(value=false)
public class AbstractTechIdCollectionPredicate
extends AbstractSpacePredicate<List<TechId>> {
    private final SpaceOwnerKind entityKind;

    private AbstractTechIdCollectionPredicate(SpaceOwnerKind entityKind) {
        this.entityKind = entityKind;
    }

    @Override
    public String getCandidateDescription() {
        return (Object)((Object)this.entityKind) + " technical id collection";
    }

    @Override
    protected Status doEvaluation(PersonPE person, List<RoleWithIdentifier> allowedRoles, List<TechId> techIds) {
        assert (this.initialized) : "Predicate has not been initialized";
        Set<SpacePE> entitySpaces = this.authorizationDataProvider.getDistinctSpacesByEntityIds(this.entityKind, techIds);
        for (SpacePE space : entitySpaces) {
            Status result = this.evaluateSpace(person, allowedRoles, space);
            if (result.isOK()) continue;
            return result;
        }
        return Status.OK;
    }

    public static class ProjectTechIdCollectionPredicate
    extends AbstractTechIdCollectionPredicate {
        public ProjectTechIdCollectionPredicate() {
            super(SpaceOwnerKind.PROJECT);
        }

        @Override
        protected Status doEvaluation(PersonPE person, List<RoleWithIdentifier> allowedRoles, List<TechId> techIds) {
            IProjectAuthorization<TechId> pa = new ProjectAuthorizationBuilder().withData(this.authorizationDataProvider).withUser(new UserProviderFromPersonPE(person)).withRoles(new RolesProviderFromRolesWithIdentifier(allowedRoles)).withObjects(new ProjectsProviderFromProjectTechIdCollection(techIds)).build();
            if (pa.getObjectsWithoutAccess().isEmpty()) {
                return Status.OK;
            }
            return super.doEvaluation(person, allowedRoles, (List<TechId>)new ArrayList<TechId>(pa.getObjectsWithoutAccess()));
        }
    }

    public static class SpaceTechIdCollectionPredicate
    extends AbstractTechIdCollectionPredicate {
        public SpaceTechIdCollectionPredicate() {
            super(SpaceOwnerKind.SPACE);
        }
    }

    public static class ExperimentTechIdCollectionPredicate
    extends AbstractTechIdCollectionPredicate {
        public ExperimentTechIdCollectionPredicate() {
            super(SpaceOwnerKind.EXPERIMENT);
        }

        @Override
        protected Status doEvaluation(PersonPE person, List<RoleWithIdentifier> allowedRoles, List<TechId> techIds) {
            IProjectAuthorization<TechId> pa = new ProjectAuthorizationBuilder().withData(this.authorizationDataProvider).withUser(new UserProviderFromPersonPE(person)).withRoles(new RolesProviderFromRolesWithIdentifier(allowedRoles)).withObjects(new ProjectsProviderFromExperimentTechIdCollection(techIds)).build();
            if (pa.getObjectsWithoutAccess().isEmpty()) {
                return Status.OK;
            }
            return super.doEvaluation(person, allowedRoles, (List<TechId>)new ArrayList<TechId>(pa.getObjectsWithoutAccess()));
        }
    }
}

