/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.authorization.predicate;

import ch.systemsx.cisd.common.exceptions.Status;
import ch.systemsx.cisd.common.exceptions.StatusFlag;
import ch.systemsx.cisd.openbis.common.conversation.context.ServiceConversationsThreadContext;
import ch.systemsx.cisd.openbis.common.conversation.progress.IServiceConversationProgressListener;
import ch.systemsx.cisd.openbis.generic.server.authorization.IAuthorizationDataProvider;
import ch.systemsx.cisd.openbis.generic.server.authorization.RoleWithIdentifier;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.AbstractPredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.IPredicate;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import java.util.List;

public final class ArrayPredicate<T>
extends AbstractPredicate<T[]> {
    private final IPredicate<T> predicate;

    public ArrayPredicate(IPredicate<T> predicate) {
        this.predicate = predicate;
    }

    protected Status itemEvaluate(PersonPE person, List<RoleWithIdentifier> allowedRoles, T item) {
        return this.predicate.evaluate(person, allowedRoles, item);
    }

    @Override
    public final void init(IAuthorizationDataProvider provider) {
        this.predicate.init(provider);
    }

    @Override
    public final String getCandidateDescription() {
        if (this.predicate instanceof AbstractPredicate) {
            return ((AbstractPredicate)this.predicate).getCandidateDescription();
        }
        return "array";
    }

    @Override
    protected final Status doEvaluation(PersonPE person, List<RoleWithIdentifier> allowedRoles, T[] value) {
        IServiceConversationProgressListener listener = ServiceConversationsThreadContext.getProgressListener();
        int index = 0;
        for (T item : value) {
            Status status = this.itemEvaluate(person, allowedRoles, item);
            if (!status.getFlag().equals((Object)StatusFlag.OK)) {
                return status;
            }
            listener.update("authorize", value.length, ++index);
        }
        return Status.OK;
    }
}

