/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.authorization.predicate;

import ch.systemsx.cisd.common.exceptions.Status;
import ch.systemsx.cisd.openbis.generic.server.authorization.IAuthorizationDataProvider;
import ch.systemsx.cisd.openbis.generic.server.authorization.RoleWithIdentifier;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.AbstractPredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.ProjectIdentifierPredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.SpaceIdentifierPredicate;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataSetAccessPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ProjectIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SpaceIdentifier;
import java.util.List;

public class DataSetAccessPEPredicate
extends AbstractPredicate<DataSetAccessPE> {
    private final ProjectIdentifierPredicate projectPredicate = new ProjectIdentifierPredicate(false);
    private final SpaceIdentifierPredicate spacePredicate = new SpaceIdentifierPredicate(false);

    @Override
    public final void init(IAuthorizationDataProvider provider) {
        this.projectPredicate.init(provider);
        this.spacePredicate.init(provider);
    }

    @Override
    public final String getCandidateDescription() {
        return "data set access";
    }

    @Override
    protected final Status doEvaluation(PersonPE person, List<RoleWithIdentifier> allowedRoles, DataSetAccessPE value) {
        Status projectResult;
        Status spaceResult;
        if (DataSetAccessPEPredicate.hasInstanceWritePermissions(person, allowedRoles).isOK()) {
            return Status.OK;
        }
        SpaceIdentifier spaceIdentifier = value.getSpaceIdentifier();
        if (spaceIdentifier != null && (spaceResult = this.spacePredicate.doEvaluation(person, allowedRoles, spaceIdentifier)).isOK()) {
            return Status.OK;
        }
        ProjectIdentifier projectIdentifier = value.getProjectIdentifier();
        if (projectIdentifier != null && (projectResult = this.projectPredicate.doEvaluation(person, allowedRoles, projectIdentifier)).isOK()) {
            return Status.OK;
        }
        return Status.createError((String)String.format("User '%s' does not have enough privileges.", person.getUserId()));
    }
}

