/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.authorization.predicate;

import ch.systemsx.cisd.common.exceptions.Status;
import ch.systemsx.cisd.openbis.common.conversation.context.ServiceConversationsThreadContext;
import ch.systemsx.cisd.openbis.common.conversation.progress.IServiceConversationProgressListener;
import ch.systemsx.cisd.openbis.generic.server.authorization.IAuthorizationDataProvider;
import ch.systemsx.cisd.openbis.generic.server.authorization.RoleWithIdentifier;
import ch.systemsx.cisd.openbis.generic.server.authorization.annotation.ShouldFlattenCollections;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.AbstractPredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.DataSetTechIdCollectionPredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.ExperimentAugmentedCodePredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.SampleIdentifierCollectionPredicate;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataSetUpdatesDTO;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ExperimentIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleIdentifier;
import java.util.ArrayList;
import java.util.List;

@ShouldFlattenCollections(value=false)
public class DataSetUpdatesCollectionPredicate
extends AbstractPredicate<List<? extends DataSetUpdatesDTO>> {
    private final DataSetTechIdCollectionPredicate dataSetTechIdCollectionPredicate = new DataSetTechIdCollectionPredicate();
    private final ExperimentAugmentedCodePredicate experimentIdentifierPredicate;
    private final SampleIdentifierCollectionPredicate sampleCollectionPredicate = new SampleIdentifierCollectionPredicate(false);

    public DataSetUpdatesCollectionPredicate() {
        this.experimentIdentifierPredicate = new ExperimentAugmentedCodePredicate();
    }

    @Override
    public void init(IAuthorizationDataProvider provider) {
        this.dataSetTechIdCollectionPredicate.init(provider);
        this.sampleCollectionPredicate.init(provider);
        this.experimentIdentifierPredicate.init(provider);
    }

    @Override
    public String getCandidateDescription() {
        return "data set updates collection";
    }

    @Override
    protected Status doEvaluation(PersonPE person, List<RoleWithIdentifier> allowedRoles, List<? extends DataSetUpdatesDTO> value) {
        if (DataSetUpdatesCollectionPredicate.hasInstanceWritePermissions(person, allowedRoles).isOK()) {
            return Status.OK;
        }
        IServiceConversationProgressListener progressListener = ServiceConversationsThreadContext.getProgressListener();
        ArrayList<TechId> techIds = new ArrayList<TechId>();
        ArrayList<SampleIdentifier> sampleIdentifiers = new ArrayList<SampleIdentifier>();
        int index = 0;
        for (DataSetUpdatesDTO dataSetUpdatesDTO : value) {
            Status result;
            ExperimentIdentifier experimentIdentifier;
            if (dataSetUpdatesDTO.getDatasetId() != null) {
                techIds.add(dataSetUpdatesDTO.getDatasetId());
            }
            if ((experimentIdentifier = dataSetUpdatesDTO.getExperimentIdentifierOrNull()) != null && !(result = this.experimentIdentifierPredicate.doEvaluation(person, allowedRoles, experimentIdentifier.toString())).isOK()) {
                return result;
            }
            SampleIdentifier sampleIdentifier = dataSetUpdatesDTO.getSampleIdentifierOrNull();
            if (sampleIdentifier != null) {
                sampleIdentifiers.add(sampleIdentifier);
            }
            progressListener.update("authorizeDatasetUpdates", value.size(), ++index);
        }
        Status result = this.dataSetTechIdCollectionPredicate.doEvaluation(person, allowedRoles, techIds);
        if (!result.isOK()) {
            return result;
        }
        return this.sampleCollectionPredicate.doEvaluation(person, allowedRoles, sampleIdentifiers);
    }
}

