/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.authorization.predicate;

import ch.systemsx.cisd.common.exceptions.Status;
import ch.systemsx.cisd.openbis.generic.server.authorization.IAuthorizationDataProvider;
import ch.systemsx.cisd.openbis.generic.server.authorization.RoleWithIdentifier;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.AbstractPredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.DataSetTechIdPredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.ExperimentAugmentedCodePredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.SampleIdentifierPredicate;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataSetUpdatesDTO;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ExperimentIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleIdentifier;
import java.util.List;

public class DataSetUpdatesPredicate
extends AbstractPredicate<DataSetUpdatesDTO> {
    private final DataSetTechIdPredicate dataSetTechIdPredicate = new DataSetTechIdPredicate();
    private final SampleIdentifierPredicate samplePredicate = new SampleIdentifierPredicate(false);
    private final ExperimentAugmentedCodePredicate experimentPredicate = new ExperimentAugmentedCodePredicate();

    @Override
    public final void init(IAuthorizationDataProvider provider) {
        this.dataSetTechIdPredicate.init(provider);
        this.samplePredicate.init(provider);
        this.experimentPredicate.init(provider);
    }

    @Override
    public final String getCandidateDescription() {
        return "data set updates";
    }

    @Override
    protected Status doEvaluation(PersonPE person, List<RoleWithIdentifier> allowedRoles, DataSetUpdatesDTO updates) {
        Status status = this.dataSetTechIdPredicate.doEvaluation(person, allowedRoles, updates.getDatasetId());
        if (!status.equals((Object)Status.OK)) {
            return status;
        }
        SampleIdentifier sampleIdentifierOrNull = updates.getSampleIdentifierOrNull();
        if (sampleIdentifierOrNull != null && !(status = this.samplePredicate.doEvaluation(person, allowedRoles, sampleIdentifierOrNull)).equals((Object)Status.OK)) {
            return status;
        }
        ExperimentIdentifier experimentIdentifierOrNull = updates.getExperimentIdentifierOrNull();
        if (experimentIdentifierOrNull != null && !(status = this.experimentPredicate.doEvaluation(person, allowedRoles, experimentIdentifierOrNull.toString())).equals((Object)Status.OK)) {
            return status;
        }
        return status;
    }
}

