/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.authorization.predicate;

import ch.systemsx.cisd.common.exceptions.Status;
import ch.systemsx.cisd.openbis.generic.server.authorization.RoleWithIdentifier;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.AbstractDatabaseInstancePredicate;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.RoleWithHierarchy;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import java.util.List;

public final class DatabaseInstanceIdentifierPredicate
extends AbstractDatabaseInstancePredicate<Void> {
    private final boolean isReadAccess;

    public DatabaseInstanceIdentifierPredicate(boolean isReadAccess) {
        this.isReadAccess = isReadAccess;
    }

    private static final boolean isMatching(List<RoleWithIdentifier> allowedRoles, boolean isReadAccess) {
        if (isReadAccess) {
            return true;
        }
        for (RoleWithIdentifier role : allowedRoles) {
            RoleWithHierarchy.RoleLevel roleGroup = role.getRoleLevel();
            if (!roleGroup.equals((Object)RoleWithHierarchy.RoleLevel.INSTANCE)) continue;
            return true;
        }
        return false;
    }

    @Override
    public final String getCandidateDescription() {
        return "database instance identifier";
    }

    @Override
    protected final Status doEvaluation(PersonPE person, List<RoleWithIdentifier> allowedRoles, Void v) {
        assert (this.initialized) : "Predicate has not been initialized";
        boolean matching = DatabaseInstanceIdentifierPredicate.isMatching(allowedRoles, this.isReadAccess);
        if (matching) {
            return Status.OK;
        }
        String userId = person.getUserId();
        return Status.createError((String)this.createErrorMsg(userId));
    }

    private String createErrorMsg(String userId) {
        String accessType = this.isReadAccess ? "read from" : "modify";
        return String.format("User '%s' does not have enough privileges to %s instance level entities.", userId, accessType);
    }
}

