/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.authorization.predicate;

import ch.systemsx.cisd.common.exceptions.Status;
import ch.systemsx.cisd.openbis.generic.server.authorization.IAuthorizationDataProvider;
import ch.systemsx.cisd.openbis.generic.server.authorization.RoleWithIdentifier;
import ch.systemsx.cisd.openbis.generic.server.authorization.annotation.ShouldFlattenCollections;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.AbstractSpacePredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.DataSetAccessPECollectionPredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.ExperimentAccessPECollectionPredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.SampleAccessPECollectionPredicate;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataSetAccessPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ExperimentAccessPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SampleAccessPE;
import java.util.List;
import java.util.Set;

@ShouldFlattenCollections(value=false)
public class DeletionTechIdCollectionPredicate
extends AbstractSpacePredicate<List<TechId>> {
    private ExperimentAccessPECollectionPredicate experimentAccessPECollectionPredicate = new ExperimentAccessPECollectionPredicate();
    private SampleAccessPECollectionPredicate sampleAccessPECollectionPredicate = new SampleAccessPECollectionPredicate(false);
    private DataSetAccessPECollectionPredicate dataSetAccessPECollectionPredicate = new DataSetAccessPECollectionPredicate();

    @Override
    public final void init(IAuthorizationDataProvider provider) {
        super.init(provider);
        this.experimentAccessPECollectionPredicate.init(provider);
        this.sampleAccessPECollectionPredicate.init(provider);
        this.dataSetAccessPECollectionPredicate.init(provider);
    }

    @Override
    public String getCandidateDescription() {
        return "deletion technical id";
    }

    @Override
    protected Status doEvaluation(PersonPE person, List<RoleWithIdentifier> allowedRoles, List<TechId> value) {
        Set<ExperimentAccessPE> experiments = this.authorizationDataProvider.getDeletedExperimentCollectionAccessData(value);
        Status experimentStatus = this.experimentAccessPECollectionPredicate.evaluate(person, allowedRoles, experiments);
        if (experimentStatus != Status.OK) {
            return experimentStatus;
        }
        Set<SampleAccessPE> samples = this.authorizationDataProvider.getDeletedSampleCollectionAccessData(value);
        Status sampleStatus = this.sampleAccessPECollectionPredicate.evaluate(person, allowedRoles, samples);
        if (sampleStatus != Status.OK) {
            return sampleStatus;
        }
        Set<DataSetAccessPE> dataSets = this.authorizationDataProvider.getDeletedDatasetCollectionAccessData(value);
        Status dataSetStatus = this.dataSetAccessPECollectionPredicate.evaluate(person, allowedRoles, dataSets);
        if (dataSetStatus != Status.OK) {
            return dataSetStatus;
        }
        return Status.OK;
    }
}

