/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.authorization.predicate;

import ch.systemsx.cisd.common.exceptions.Status;
import ch.systemsx.cisd.openbis.generic.server.authorization.IAuthorizationDataProvider;
import ch.systemsx.cisd.openbis.generic.server.authorization.RoleWithIdentifier;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.AbstractPredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.ProjectIdentifierPredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.SpaceIdentifierPredicate;
import ch.systemsx.cisd.openbis.generic.shared.dto.ExperimentAccessPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ProjectIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SpaceIdentifier;
import java.util.List;

public class ExperimentAccessPEPredicate
extends AbstractPredicate<ExperimentAccessPE> {
    private final ProjectIdentifierPredicate projectPredicate = new ProjectIdentifierPredicate(false);
    private final SpaceIdentifierPredicate spacePredicate = new SpaceIdentifierPredicate(false);

    @Override
    public final void init(IAuthorizationDataProvider provider) {
        this.projectPredicate.init(provider);
        this.spacePredicate.init(provider);
    }

    @Override
    public final String getCandidateDescription() {
        return "experiment access";
    }

    @Override
    protected final Status doEvaluation(PersonPE person, List<RoleWithIdentifier> allowedRoles, ExperimentAccessPE value) {
        if (ExperimentAccessPEPredicate.hasInstanceWritePermissions(person, allowedRoles).isOK()) {
            return Status.OK;
        }
        Status spaceResult = this.spacePredicate.doEvaluation(person, allowedRoles, new SpaceIdentifier(value.getSpaceCode()));
        if (spaceResult.isOK()) {
            return Status.OK;
        }
        Status projectResult = this.projectPredicate.doEvaluation(person, allowedRoles, new ProjectIdentifier(value.getSpaceCode(), value.getProjectCode()));
        if (projectResult.isOK()) {
            return Status.OK;
        }
        return spaceResult;
    }
}

