/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.authorization.predicate;

import ch.systemsx.cisd.common.exceptions.Status;
import ch.systemsx.cisd.openbis.generic.server.authorization.RoleWithIdentifier;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.DelegatedPredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.SpaceIdentifierPredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.project.IProjectAuthorization;
import ch.systemsx.cisd.openbis.generic.server.authorization.project.ProjectAuthorizationBuilder;
import ch.systemsx.cisd.openbis.generic.server.authorization.project.provider.project.ProjectProviderFromExperimentIdentifierString;
import ch.systemsx.cisd.openbis.generic.server.authorization.project.provider.role.RolesProviderFromRolesWithIdentifier;
import ch.systemsx.cisd.openbis.generic.server.authorization.project.provider.user.UserProviderFromPersonPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ExperimentIdentifierFactory;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SpaceIdentifier;
import java.util.List;

public class ExperimentAugmentedCodePredicate
extends DelegatedPredicate<SpaceIdentifier, String> {
    public ExperimentAugmentedCodePredicate() {
        this(false);
    }

    public ExperimentAugmentedCodePredicate(boolean okForNonExistentSpaces) {
        super(new SpaceIdentifierPredicate(okForNonExistentSpaces));
    }

    @Override
    public SpaceIdentifier tryConvert(String value) {
        return new ExperimentIdentifierFactory(value).createIdentifier();
    }

    @Override
    public Status doEvaluation(PersonPE person, List<RoleWithIdentifier> allowedRoles, String value) {
        IProjectAuthorization<String> pa = new ProjectAuthorizationBuilder().withData(this.authorizationDataProvider).withUser(new UserProviderFromPersonPE(person)).withRoles(new RolesProviderFromRolesWithIdentifier(allowedRoles)).withObjects(new ProjectProviderFromExperimentIdentifierString(value)).build();
        if (pa.getObjectsWithoutAccess().isEmpty()) {
            return Status.OK;
        }
        return super.doEvaluation(person, allowedRoles, value);
    }

    @Override
    public String getCandidateDescription() {
        return "experiment";
    }
}

