/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.authorization.predicate;

import ch.systemsx.cisd.common.db.mapper.LongArrayMapper;
import ch.systemsx.cisd.common.db.mapper.StringArrayMapper;
import ch.systemsx.cisd.common.exceptions.AuthorizationFailureException;
import ch.systemsx.cisd.common.exceptions.Status;
import ch.systemsx.cisd.openbis.generic.server.authorization.RoleWithIdentifier;
import ch.systemsx.cisd.openbis.generic.server.authorization.annotation.ShouldFlattenCollections;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.AbstractSpacePredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.project.IProjectAuthorization;
import ch.systemsx.cisd.openbis.generic.server.authorization.project.ProjectAuthorizationBuilder;
import ch.systemsx.cisd.openbis.generic.server.authorization.project.provider.project.ProjectsProviderFromExperimentV1Collection;
import ch.systemsx.cisd.openbis.generic.server.authorization.project.provider.role.RolesProviderFromRolesWithIdentifier;
import ch.systemsx.cisd.openbis.generic.server.authorization.project.provider.user.UserProviderFromPersonPE;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.Experiment;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ExperimentIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ExperimentIdentifierFactory;
import ch.systemsx.cisd.openbis.generic.shared.util.SpaceCodeHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import net.lemnik.eodsql.BaseQuery;
import net.lemnik.eodsql.QueryTool;
import net.lemnik.eodsql.Select;

@ShouldFlattenCollections(value=false)
public class ExperimentListPredicate
extends AbstractSpacePredicate<List<Experiment>> {
    private static final int ARRAY_SIZE_LIMIT = 999;
    private IExperimentToSpaceQuery experimentToSpaceQuery = (IExperimentToSpaceQuery)QueryTool.getManagedQuery(IExperimentToSpaceQuery.class);

    @Override
    public String getCandidateDescription() {
        return "experiment";
    }

    @Override
    protected Status doEvaluation(PersonPE person, List<RoleWithIdentifier> allowedRoles, List<Experiment> experiments) {
        IProjectAuthorization<Experiment> pa = new ProjectAuthorizationBuilder().withData(this.authorizationDataProvider).withUser(new UserProviderFromPersonPE(person)).withRoles(new RolesProviderFromRolesWithIdentifier(allowedRoles)).withObjects(new ProjectsProviderFromExperimentV1Collection(experiments)).build();
        if (pa.getObjectsWithoutAccess().isEmpty()) {
            return Status.OK;
        }
        Collection<Experiment> remainingExperiments = pa.getObjectsWithoutAccess();
        ArrayList<Long> ids = new ArrayList<Long>(remainingExperiments.size());
        ArrayList<String> permIds = new ArrayList<String>(remainingExperiments.size());
        for (Experiment experiment : remainingExperiments) {
            if (experiment.getId() == null) {
                throw new AuthorizationFailureException("id is undefined.");
            }
            ids.add(experiment.getId());
            if (experiment.getPermId() == null) {
                throw new AuthorizationFailureException("permId is undefined.");
            }
            permIds.add(experiment.getPermId());
            ExperimentIdentifier spaceIdentifier = new ExperimentIdentifierFactory(experiment.getIdentifier()).createIdentifier();
            String spaceCode = SpaceCodeHelper.getSpaceCode(person, spaceIdentifier);
            Status status = this.evaluate(allowedRoles, person, spaceCode);
            if (Status.OK.equals((Object)status)) continue;
            return status;
        }
        for (String spaceCode : this.getExperimentSpaceCodes(ids, permIds)) {
            Status status = this.evaluate(allowedRoles, person, spaceCode);
            if (Status.OK.equals((Object)status)) continue;
            return status;
        }
        return Status.OK;
    }

    private Collection<String> getExperimentSpaceCodes(List<Long> ids, List<String> permIds) {
        if (ids.size() != permIds.size()) {
            throw new IllegalArgumentException("Expect to get the same number of ids and permIds.");
        }
        int size = ids.size();
        if (size == 0) {
            return Collections.emptyList();
        }
        if (size > 999) {
            HashSet<String> spaceCodes = new HashSet<String>(size);
            for (int startIdx = 0; startIdx < size; startIdx += 999) {
                List<Long> idSubList = ids.subList(startIdx, Math.min(size, startIdx + 999));
                List<String> permIdSubList = permIds.subList(startIdx, Math.min(size, startIdx + 999));
                spaceCodes.addAll(this.experimentToSpaceQuery.getExperimentSpaceCodes(this.toArray(idSubList), permIdSubList.toArray(new String[permIdSubList.size()])));
            }
            return spaceCodes;
        }
        return this.experimentToSpaceQuery.getExperimentSpaceCodes(this.toArray(ids), permIds.toArray(new String[size]));
    }

    private long[] toArray(List<Long> list) {
        long[] result = new long[list.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = list.get(i);
        }
        return result;
    }

    void setExperimentToSpaceQuery(IExperimentToSpaceQuery experimentToSpaceQuery) {
        this.experimentToSpaceQuery = experimentToSpaceQuery;
    }

    public static interface IExperimentToSpaceQuery
    extends BaseQuery {
        @Select(sql="select distinct s.code from spaces s left join projects p on p.space_id = s.id left join experiments e on e.proj_id = p.id where e.id = any(?{1}) union select distinct s.code from spaces s left join projects p on p.space_id = s.id left join experiments e on e.proj_id = p.id where e.perm_id = any(?{2})", parameterBindings={LongArrayMapper.class, StringArrayMapper.class})
        public List<String> getExperimentSpaceCodes(long[] var1, String[] var2);
    }
}

