/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.authorization.predicate;

import ch.systemsx.cisd.common.exceptions.Status;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.generic.server.authorization.RoleWithIdentifier;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.PersistentEntityPredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.project.IProjectAuthorization;
import ch.systemsx.cisd.openbis.generic.server.authorization.project.ProjectAuthorizationBuilder;
import ch.systemsx.cisd.openbis.generic.server.authorization.project.provider.project.ProjectProviderFromExperimentPE;
import ch.systemsx.cisd.openbis.generic.server.authorization.project.provider.role.RolesProviderFromRolesWithIdentifier;
import ch.systemsx.cisd.openbis.generic.server.authorization.project.provider.user.UserProviderFromPersonPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ExperimentPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SpacePE;
import java.util.List;

public class ExperimentPEPredicate
extends PersistentEntityPredicate<ExperimentPE> {
    public ExperimentPEPredicate() {
    }

    public ExperimentPEPredicate(boolean isReadAccess) {
        super(isReadAccess);
    }

    @Override
    public SpacePE getSpace(ExperimentPE experiment) {
        return experiment == null ? null : experiment.getProject().getSpace();
    }

    @Override
    public Status evaluate(PersonPE person, List<RoleWithIdentifier> allowedRoles, ExperimentPE value) throws UserFailureException {
        IProjectAuthorization<ExperimentPE> pa = new ProjectAuthorizationBuilder().withData(this.provider).withUser(new UserProviderFromPersonPE(person)).withRoles(new RolesProviderFromRolesWithIdentifier(allowedRoles)).withObjects(new ProjectProviderFromExperimentPE(value)).build();
        if (pa.getObjectsWithoutAccess().isEmpty()) {
            return Status.OK;
        }
        return super.evaluate(person, allowedRoles, value);
    }
}

