/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.authorization.predicate;

import ch.systemsx.cisd.common.exceptions.Status;
import ch.systemsx.cisd.openbis.generic.server.authorization.IAuthorizationDataProvider;
import ch.systemsx.cisd.openbis.generic.server.authorization.RoleWithIdentifier;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.AbstractDatabaseInstancePredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.ExperimentPEPredicate;
import ch.systemsx.cisd.openbis.generic.shared.dto.ExperimentPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.PermId;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import java.util.List;

public class ExperimentPermIdPredicate
extends AbstractDatabaseInstancePredicate<PermId> {
    private final ExperimentPEPredicate experimentPEPredicate;

    public ExperimentPermIdPredicate() {
        this(true);
    }

    public ExperimentPermIdPredicate(boolean isReadAccess) {
        this.experimentPEPredicate = new ExperimentPEPredicate(isReadAccess);
    }

    @Override
    public final void init(IAuthorizationDataProvider provider) {
        super.init(provider);
        this.experimentPEPredicate.init(provider);
    }

    @Override
    public final String getCandidateDescription() {
        return "experiment perm id";
    }

    @Override
    protected final Status doEvaluation(PersonPE person, List<RoleWithIdentifier> allowedRoles, PermId id) {
        ExperimentPE experiment = this.authorizationDataProvider.tryGetExperimentByPermId(id.getId());
        if (experiment == null) {
            return Status.OK;
        }
        return this.experimentPEPredicate.evaluate(person, allowedRoles, experiment);
    }
}

