/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.authorization.predicate;

import ch.systemsx.cisd.common.exceptions.Status;
import ch.systemsx.cisd.openbis.generic.server.authorization.RoleWithIdentifier;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.AbstractExperimentPredicate;
import ch.systemsx.cisd.openbis.generic.shared.dto.ExperimentUpdatesDTO;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import java.util.List;

public class ExperimentUpdatesPredicate
extends AbstractExperimentPredicate<ExperimentUpdatesDTO> {
    @Override
    public final String getCandidateDescription() {
        return "experiment updates";
    }

    @Override
    protected Status doEvaluation(PersonPE person, List<RoleWithIdentifier> allowedRoles, ExperimentUpdatesDTO updates) {
        assert (this.projectPredicate.initialized) : "Predicate has not been initialized";
        assert (this.experimentTechIdPredicate.initialized) : "Predicate has not been initialized";
        if (ExperimentUpdatesPredicate.hasInstanceWritePermissions(person, allowedRoles).isOK()) {
            return Status.OK;
        }
        Status status = this.experimentTechIdPredicate.doEvaluation(person, allowedRoles, updates.getExperimentId());
        if (!status.equals((Object)Status.OK)) {
            return status;
        }
        if (updates.getProjectIdentifier() != null) {
            status = this.projectPredicate.doEvaluation(person, allowedRoles, updates.getProjectIdentifier());
            return status;
        }
        return Status.OK;
    }
}

