/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.authorization.predicate;

import ch.systemsx.cisd.common.exceptions.Status;
import ch.systemsx.cisd.openbis.generic.server.authorization.IAuthorizationDataProvider;
import ch.systemsx.cisd.openbis.generic.server.authorization.RoleWithIdentifier;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.AbstractPredicate;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.dto.MetaprojectPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import java.util.List;

public class MetaprojectTechIdPredicate
extends AbstractPredicate<TechId> {
    private IAuthorizationDataProvider authorizationDataProvider;

    @Override
    public void init(IAuthorizationDataProvider provider) {
        this.authorizationDataProvider = provider;
    }

    @Override
    public String getCandidateDescription() {
        return "Metaproject TechId";
    }

    @Override
    protected Status doEvaluation(PersonPE person, List<RoleWithIdentifier> allowedRoles, TechId metaprojectId) {
        MetaprojectPE metaprojectPE = this.authorizationDataProvider.getMetaproject(metaprojectId);
        if (metaprojectPE.getOwner().getId().longValue() == person.getId().longValue()) {
            return Status.OK;
        }
        return Status.createError((String)String.format("User '%s' is not an owner of the metaproject '%s'.", person.getUserId(), metaprojectPE.getName()));
    }
}

