/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.authorization.predicate;

import ch.systemsx.cisd.common.exceptions.Status;
import ch.systemsx.cisd.openbis.generic.server.authorization.IAuthorizationDataProvider;
import ch.systemsx.cisd.openbis.generic.server.authorization.RoleWithIdentifier;
import ch.systemsx.cisd.openbis.generic.server.authorization.annotation.ShouldFlattenCollections;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.AbstractPredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.DataSetCodeCollectionPredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.ExperimentAugmentedCodePredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.SampleAugmentedCodePredicate;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewDataSet;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewDataSetsWithTypes;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

@ShouldFlattenCollections(value=false)
public class NewDataSetsWithTypePredicate
extends AbstractPredicate<NewDataSetsWithTypes> {
    private final DataSetCodeCollectionPredicate dataSetCodeCollectionPredicate = new DataSetCodeCollectionPredicate();
    private final SampleAugmentedCodePredicate sampleIdentifierPredicate = new SampleAugmentedCodePredicate(false);
    private final ExperimentAugmentedCodePredicate experimentIdentifierPredicate = new ExperimentAugmentedCodePredicate();

    @Override
    public void init(IAuthorizationDataProvider provider) {
        this.dataSetCodeCollectionPredicate.init(provider);
        this.sampleIdentifierPredicate.init(provider);
        this.experimentIdentifierPredicate.init(provider);
    }

    @Override
    protected Status doEvaluation(PersonPE person, List<RoleWithIdentifier> allowedRoles, NewDataSetsWithTypes dataSets) {
        if (dataSets == null || dataSets.getNewDataSets() == null || dataSets.getNewDataSets().isEmpty()) {
            return Status.OK;
        }
        Status status = this.dataSetCodeCollectionPredicate.doEvaluation(person, allowedRoles, this.getDataSetCodes(dataSets.getNewDataSets()));
        if (status.isError()) {
            return status;
        }
        Collection<String> sampleIdentifiers = this.getSampleIdentifiers(dataSets.getNewDataSets());
        for (String sampleIdentifier : sampleIdentifiers) {
            status = this.sampleIdentifierPredicate.doEvaluation(person, allowedRoles, sampleIdentifier);
            if (!status.isError()) continue;
            return status;
        }
        Collection<String> experimentIdentifiers = this.getExperimentIdentifiers(dataSets.getNewDataSets());
        for (String experimentIdentifier : experimentIdentifiers) {
            status = this.experimentIdentifierPredicate.doEvaluation(person, allowedRoles, experimentIdentifier);
            if (!status.isError()) continue;
            return status;
        }
        status = this.dataSetCodeCollectionPredicate.doEvaluation(person, allowedRoles, this.getParentCodes(dataSets.getNewDataSets()));
        if (status.isError()) {
            return status;
        }
        status = this.dataSetCodeCollectionPredicate.doEvaluation(person, allowedRoles, this.getContainerCodes(dataSets.getNewDataSets()));
        if (status.isError()) {
            return status;
        }
        return status;
    }

    private List<String> getDataSetCodes(List<NewDataSet> dataSets) {
        HashSet<String> dataSetCodes = new HashSet<String>();
        for (NewDataSet dataSet : dataSets) {
            if (dataSet.getCode() == null) continue;
            dataSetCodes.add(dataSet.getCode());
        }
        return new ArrayList<String>(dataSetCodes);
    }

    private Collection<String> getSampleIdentifiers(List<NewDataSet> dataSets) {
        HashSet<String> sampleIdentifiers = new HashSet<String>();
        for (NewDataSet dataSet : dataSets) {
            if (dataSet.getSampleIdentifierOrNull() == null) continue;
            sampleIdentifiers.add(dataSet.getSampleIdentifierOrNull());
        }
        return sampleIdentifiers;
    }

    private Collection<String> getExperimentIdentifiers(List<NewDataSet> dataSets) {
        HashSet<String> experimentIdentifiers = new HashSet<String>();
        for (NewDataSet dataSet : dataSets) {
            if (dataSet.getExperimentIdentifier() == null) continue;
            experimentIdentifiers.add(dataSet.getExperimentIdentifier());
        }
        return experimentIdentifiers;
    }

    private List<String> getParentCodes(List<NewDataSet> dataSets) {
        HashSet<String> parentCodes = new HashSet<String>();
        for (NewDataSet dataSet : dataSets) {
            if (dataSet.getParentsIdentifiersOrNull() == null) continue;
            for (String parentCode : dataSet.getParentsIdentifiersOrNull()) {
                parentCodes.add(parentCode);
            }
        }
        return new ArrayList<String>(parentCodes);
    }

    private List<String> getContainerCodes(List<NewDataSet> dataSets) {
        HashSet<String> containerCodes = new HashSet<String>();
        for (NewDataSet dataSet : dataSets) {
            if (dataSet.getContainerIdentifierOrNull() == null) continue;
            containerCodes.add(dataSet.getContainerIdentifierOrNull());
        }
        return new ArrayList<String>(containerCodes);
    }

    @Override
    public String getCandidateDescription() {
        return "new data sets";
    }
}

