/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.authorization.predicate;

import ch.systemsx.cisd.common.exceptions.Status;
import ch.systemsx.cisd.openbis.generic.server.authorization.IAuthorizationDataProvider;
import ch.systemsx.cisd.openbis.generic.server.authorization.RoleWithIdentifier;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.AbstractPredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.DataSetCodeCollectionPredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.ExperimentAugmentedCodePredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.SampleIdentifierPredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.SamplePermIdStringPredicate;
import ch.systemsx.cisd.openbis.generic.shared.dto.NewExternalData;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import java.util.List;

public class NewExternalDataPredicate
extends AbstractPredicate<NewExternalData> {
    private final SampleIdentifierPredicate sampleIdentifierPredicate = new SampleIdentifierPredicate(false, true);
    private final SamplePermIdStringPredicate samplePermIdPredicate = new SamplePermIdStringPredicate(false);
    private final ExperimentAugmentedCodePredicate experimentIdentifierPredicate = new ExperimentAugmentedCodePredicate(true);
    private final DataSetCodeCollectionPredicate dataSetCodeCollectionPredicate = new DataSetCodeCollectionPredicate();

    @Override
    public void init(IAuthorizationDataProvider provider) {
        this.sampleIdentifierPredicate.init(provider);
        this.samplePermIdPredicate.init(provider);
        this.experimentIdentifierPredicate.init(provider);
        this.dataSetCodeCollectionPredicate.init(provider);
    }

    @Override
    public String getCandidateDescription() {
        return "new data set";
    }

    @Override
    protected Status doEvaluation(PersonPE person, List<RoleWithIdentifier> allowedRoles, NewExternalData value) {
        Status status;
        if (NewExternalDataPredicate.hasInstanceWritePermissions(person, allowedRoles).isOK()) {
            return Status.OK;
        }
        if (value.getSampleIdentifierOrNull() != null && (status = this.sampleIdentifierPredicate.evaluate(person, allowedRoles, value.getSampleIdentifierOrNull())).isError()) {
            return status;
        }
        if (value.getSamplePermIdOrNull() != null && (status = this.samplePermIdPredicate.evaluate(person, allowedRoles, value.getSamplePermIdOrNull())).isError()) {
            return status;
        }
        if (value.getExperimentIdentifierOrNull() != null && (status = this.experimentIdentifierPredicate.evaluate(person, allowedRoles, value.getExperimentIdentifierOrNull().toString())).isError()) {
            return status;
        }
        if (value.getParentDataSetCodes() != null && (status = this.dataSetCodeCollectionPredicate.evaluate(person, allowedRoles, value.getParentDataSetCodes())).isError()) {
            return status;
        }
        return Status.OK;
    }
}

