/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.authorization.predicate;

import ch.systemsx.cisd.common.exceptions.Status;
import ch.systemsx.cisd.openbis.generic.server.authorization.IAuthorizationDataProvider;
import ch.systemsx.cisd.openbis.generic.server.authorization.RoleWithIdentifier;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.AbstractPredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.SampleIdentifierPredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.project.IProjectAuthorization;
import ch.systemsx.cisd.openbis.generic.server.authorization.project.ProjectAuthorizationBuilder;
import ch.systemsx.cisd.openbis.generic.server.authorization.project.provider.project.ProjectProviderFromExperimentIdentifierString;
import ch.systemsx.cisd.openbis.generic.server.authorization.project.provider.project.ProjectProviderFromProjectPE;
import ch.systemsx.cisd.openbis.generic.server.authorization.project.provider.role.RolesProviderFromRolesWithIdentifier;
import ch.systemsx.cisd.openbis.generic.server.authorization.project.provider.user.UserProviderFromPersonPE;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewSample;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ProjectPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SamplePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SpacePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleIdentifierFactory;
import java.util.List;

public class NewSampleIdentifierPredicate
extends AbstractPredicate<NewSample> {
    private IAuthorizationDataProvider dataProvider;

    @Override
    public void init(IAuthorizationDataProvider provider) {
        this.dataProvider = provider;
    }

    @Override
    public String getCandidateDescription() {
        return "new sample identifier";
    }

    @Override
    protected Status doEvaluation(final PersonPE person, final List<RoleWithIdentifier> allowedRoles, final NewSample value) {
        SampleIdentifier identifier = SampleIdentifierFactory.parse(value.getIdentifier(), value.getDefaultSpaceIdentifier());
        SampleIdentifierPredicate identifierPredicate = new SampleIdentifierPredicate(false, true){

            @Override
            protected Status doEvaluationOfExperimentProject(PersonPE iPerson, List<RoleWithIdentifier> iAllowedRoles, SampleIdentifier iValue) {
                return NewSampleIdentifierPredicate.this.doEvaluationOfExperimentProject(person, allowedRoles, value);
            }
        };
        identifierPredicate.init(this.dataProvider);
        return identifierPredicate.doEvaluation(person, allowedRoles, identifier);
    }

    private Status doEvaluationOfExperimentProject(PersonPE person, List<RoleWithIdentifier> allowedRoles, NewSample value) {
        SampleIdentifier identifier = SampleIdentifierFactory.parse(value.getIdentifier(), value.getDefaultSpaceIdentifier());
        SpacePE space = this.dataProvider.tryGetSpace(identifier.getSpaceLevel().getSpaceCode());
        if (space != null) {
            SamplePE sample = this.dataProvider.tryGetSampleBySpaceAndCode(space, identifier.getSampleCode());
            if (sample == null) {
                IProjectAuthorization<String> pa;
                if (value.getExperimentIdentifier() != null && (pa = new ProjectAuthorizationBuilder().withData(this.dataProvider).withUser(new UserProviderFromPersonPE(person)).withRoles(new RolesProviderFromRolesWithIdentifier(allowedRoles)).withObjects(new ProjectProviderFromExperimentIdentifierString(value.getExperimentIdentifier())).build()).getObjectsWithoutAccess().isEmpty()) {
                    return Status.OK;
                }
            } else {
                ProjectPE project = sample.getExperiment() != null ? sample.getExperiment().getProject() : null;
                IProjectAuthorization<ProjectPE> pa = new ProjectAuthorizationBuilder().withData(this.dataProvider).withUser(new UserProviderFromPersonPE(person)).withRoles(new RolesProviderFromRolesWithIdentifier(allowedRoles)).withObjects(new ProjectProviderFromProjectPE(project)).build();
                if (pa.getObjectsWithoutAccess().isEmpty()) {
                    return Status.OK;
                }
            }
        }
        return Status.createError();
    }
}

