/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.authorization.predicate;

import ch.systemsx.cisd.common.exceptions.Status;
import ch.systemsx.cisd.openbis.generic.server.authorization.IAuthorizationDataProvider;
import ch.systemsx.cisd.openbis.generic.server.authorization.RoleWithIdentifier;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.AbstractPredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.NewSampleIdentifierPredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.ProjectIdentifierPredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.SampleIdentifierPredicate;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewSample;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ExperimentIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ExperimentIdentifierFactory;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ProjectIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ProjectIdentifierFactory;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleIdentifierFactory;
import java.util.List;

public final class NewSamplePredicate
extends AbstractPredicate<NewSample> {
    private ProjectIdentifierPredicate projectIdentifierPredicate = new ProjectIdentifierPredicate(true);
    private SampleIdentifierPredicate sampleIdentifierPredicate = new SampleIdentifierPredicate(false, true);
    private NewSampleIdentifierPredicate newSampleIdentifierPredicate = new NewSampleIdentifierPredicate();

    @Override
    public void init(IAuthorizationDataProvider provider) {
        this.projectIdentifierPredicate.init(provider);
        this.sampleIdentifierPredicate.init(provider);
        this.newSampleIdentifierPredicate.init(provider);
    }

    @Override
    protected Status doEvaluation(PersonPE person, List<RoleWithIdentifier> allowedRoles, NewSample value) {
        SampleIdentifier containerIdentifier;
        ExperimentIdentifier experimentIdentifier;
        ProjectIdentifier projectIdentifier;
        if (NewSamplePredicate.hasInstanceWritePermissions(person, allowedRoles).isOK()) {
            return Status.OK;
        }
        Status status = Status.OK;
        if (value.getProjectIdentifier() == null && value.getExperimentIdentifier() == null && value.getIdentifier() != null && !(status = this.newSampleIdentifierPredicate.doEvaluation(person, allowedRoles, value)).equals((Object)Status.OK)) {
            return status;
        }
        if (value.getProjectIdentifier() != null && !(status = this.projectIdentifierPredicate.doEvaluation(person, allowedRoles, projectIdentifier = ProjectIdentifierFactory.parse(value.getProjectIdentifier(), value.getDefaultSpaceIdentifier()))).equals((Object)Status.OK)) {
            return status;
        }
        if (value.getExperimentIdentifier() != null && !(status = this.projectIdentifierPredicate.doEvaluation(person, allowedRoles, experimentIdentifier = ExperimentIdentifierFactory.parse(value.getExperimentIdentifier(), value.getDefaultSpaceIdentifier()))).equals((Object)Status.OK)) {
            return status;
        }
        if (value.getContainerIdentifierForNewSample() != null && !(status = this.sampleIdentifierPredicate.doEvaluation(person, allowedRoles, containerIdentifier = SampleIdentifierFactory.parse(value.getContainerIdentifierForNewSample(), value.getDefaultSpaceIdentifier()))).equals((Object)Status.OK)) {
            return status;
        }
        if (value.getParentsOrNull() != null && value.getParentsOrNull().length > 0) {
            for (String parent : value.getParentsOrNull()) {
                SampleIdentifier parentIdentifier = SampleIdentifierFactory.parse(parent, value.getDefaultSpaceIdentifier());
                status = this.sampleIdentifierPredicate.doEvaluation(person, allowedRoles, parentIdentifier);
                if (status.equals((Object)Status.OK)) continue;
                return status;
            }
        }
        return status;
    }

    @Override
    public final String getCandidateDescription() {
        return "new sample";
    }
}

