/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.authorization.predicate;

import ch.systemsx.cisd.common.exceptions.Status;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.generic.server.authorization.IAuthorizationDataProvider;
import ch.systemsx.cisd.openbis.generic.server.authorization.RoleWithIdentifier;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.IPredicate;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.RoleWithHierarchy;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SpacePE;
import java.util.List;

public abstract class PersistentEntityPredicate<T>
implements IPredicate<T> {
    private final boolean isReadAccess;
    protected IAuthorizationDataProvider provider;

    public PersistentEntityPredicate() {
        this(false);
    }

    public PersistentEntityPredicate(boolean isReadAccess) {
        this.isReadAccess = isReadAccess;
    }

    @Override
    public Status evaluate(PersonPE person, List<RoleWithIdentifier> allowedRoles, T value) throws UserFailureException {
        boolean isInstanceEntity;
        SpacePE space = this.getSpace(value);
        boolean bl = isInstanceEntity = space == null;
        if (isInstanceEntity && this.isReadAccess) {
            return Status.OK;
        }
        for (RoleWithIdentifier allowed : allowedRoles) {
            RoleWithHierarchy.RoleLevel level = allowed.getRoleLevel();
            if (level.equals((Object)RoleWithHierarchy.RoleLevel.INSTANCE)) {
                return Status.OK;
            }
            if (!level.equals((Object)RoleWithHierarchy.RoleLevel.SPACE) || !allowed.getAssignedSpace().equals(space)) continue;
            return Status.OK;
        }
        return Status.createError((String)(person.getUserId() + " does not have enough privileges."));
    }

    public abstract SpacePE getSpace(T var1);

    @Override
    public void init(IAuthorizationDataProvider provider) {
        this.provider = provider;
    }
}

