/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.authorization.predicate;

import ch.systemsx.cisd.common.exceptions.Status;
import ch.systemsx.cisd.openbis.generic.server.authorization.RoleWithIdentifier;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.AbstractProjectPredicate;
import ch.systemsx.cisd.openbis.generic.shared.dto.PermId;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ProjectPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ProjectUpdatesDTO;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ProjectIdentifierFactory;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SpaceIdentifier;
import java.util.List;

public class ProjectUpdatesPredicate
extends AbstractProjectPredicate<ProjectUpdatesDTO> {
    @Override
    public final String getCandidateDescription() {
        return "project updates";
    }

    @Override
    protected Status doEvaluation(PersonPE person, List<RoleWithIdentifier> allowedRoles, ProjectUpdatesDTO updates) {
        assert (this.spacePredicate.initialized) : "Predicate has not been initialized";
        assert (this.projectTechIdPredicate.initialized) : "Predicate has not been initialized";
        assert (this.projectPermIdPredicate.initialized) : "Predicate has not been initialized";
        assert (this.projectAugmentedCodePredicate.initialized) : "Predicate has not been initialized";
        Status status = updates.getTechId() != null ? this.projectTechIdPredicate.doEvaluation(person, allowedRoles, updates.getTechId()) : (updates.getPermId() != null ? this.projectPermIdPredicate.doEvaluation(person, allowedRoles, new PermId(updates.getPermId())) : this.projectAugmentedCodePredicate.doEvaluation(person, allowedRoles, updates.getIdentifier()));
        if (!status.equals((Object)Status.OK)) {
            return status;
        }
        ProjectPE project = this.tryGetProject(updates);
        if (project != null) {
            String oldSpaceCode = project.getSpace().getCode();
            String newSpaceCode = updates.getSpaceCode();
            if (newSpaceCode != null && !newSpaceCode.equals(oldSpaceCode)) {
                status = this.spacePredicate.doEvaluation(person, allowedRoles, new SpaceIdentifier(newSpaceCode));
            }
        }
        return status;
    }

    private ProjectPE tryGetProject(ProjectUpdatesDTO updates) {
        if (updates.getTechId() != null) {
            return this.provider.tryGetProjectByTechId(updates.getTechId());
        }
        if (updates.getPermId() != null) {
            return this.provider.tryGetProjectByPermId(new PermId(updates.getPermId()));
        }
        if (updates.getIdentifier() != null) {
            return this.provider.tryGetProjectByIdentifier(ProjectIdentifierFactory.parse(updates.getIdentifier()));
        }
        return null;
    }
}

