/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.authorization.predicate;

import ch.systemsx.cisd.common.exceptions.Status;
import ch.systemsx.cisd.openbis.generic.server.authorization.IAuthorizationDataProvider;
import ch.systemsx.cisd.openbis.generic.server.authorization.RoleWithIdentifier;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.AbstractPredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.DatabaseInstanceIdentifierPredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.ProjectIdentifierPredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.SpaceIdentifierPredicate;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SampleAccessPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ProjectIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SpaceIdentifier;
import java.util.List;

public class SampleAccessPEPredicate
extends AbstractPredicate<SampleAccessPE> {
    private final ProjectIdentifierPredicate projectPredicate = new ProjectIdentifierPredicate(false);
    private final SpaceIdentifierPredicate spacePredicate = new SpaceIdentifierPredicate(false);
    private final DatabaseInstanceIdentifierPredicate databaseInstanceIdentifierPredicate;

    public SampleAccessPEPredicate() {
        this(true);
    }

    public SampleAccessPEPredicate(boolean isReadAccess) {
        this.databaseInstanceIdentifierPredicate = new DatabaseInstanceIdentifierPredicate(isReadAccess);
    }

    @Override
    public final void init(IAuthorizationDataProvider provider) {
        this.projectPredicate.init(provider);
        this.spacePredicate.init(provider);
        this.databaseInstanceIdentifierPredicate.init(provider);
    }

    @Override
    public final String getCandidateDescription() {
        return "sample access";
    }

    @Override
    protected final Status doEvaluation(PersonPE person, List<RoleWithIdentifier> allowedRoles, SampleAccessPE value) {
        if (SampleAccessPEPredicate.hasInstanceWritePermissions(person, allowedRoles).isOK()) {
            return Status.OK;
        }
        if (value.getSpaceCode() != null) {
            Status projectResult;
            String projectCode;
            Status spaceResult = this.spacePredicate.doEvaluation(person, allowedRoles, new SpaceIdentifier(value.getSpaceCode()));
            if (spaceResult.isOK()) {
                return Status.OK;
            }
            String string = projectCode = value.getProjectCode() != null ? value.getProjectCode() : value.getExperimentProjectCode();
            if (projectCode != null && (projectResult = this.projectPredicate.doEvaluation(person, allowedRoles, new ProjectIdentifier(value.getSpaceCode(), projectCode))).isOK()) {
                return Status.OK;
            }
            return spaceResult;
        }
        return this.databaseInstanceIdentifierPredicate.doEvaluation(person, allowedRoles, null);
    }
}

