/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.authorization.predicate;

import ch.systemsx.cisd.common.exceptions.Status;
import ch.systemsx.cisd.openbis.generic.server.authorization.IAuthorizationDataProvider;
import ch.systemsx.cisd.openbis.generic.server.authorization.RoleWithIdentifier;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.AbstractPredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.DatabaseInstanceIdentifierPredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.SpaceIdentifierPredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.project.IProjectAuthorization;
import ch.systemsx.cisd.openbis.generic.server.authorization.project.ProjectAuthorizationBuilder;
import ch.systemsx.cisd.openbis.generic.server.authorization.project.provider.project.ProjectProviderFromProjectIdentifierObject;
import ch.systemsx.cisd.openbis.generic.server.authorization.project.provider.project.ProjectProviderFromSpaceCodeAndSampleCode;
import ch.systemsx.cisd.openbis.generic.server.authorization.project.provider.role.RolesProviderFromRolesWithIdentifier;
import ch.systemsx.cisd.openbis.generic.server.authorization.project.provider.user.UserProviderFromPersonPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ProjectIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.util.SpaceCodeHelper;
import java.util.List;

public class SampleIdentifierPredicate
extends AbstractPredicate<SampleIdentifier> {
    private IAuthorizationDataProvider dataProvider;
    private final SpaceIdentifierPredicate spacePredicate;
    private final DatabaseInstanceIdentifierPredicate databaseInstanceIdentifierPredicate;
    boolean initialized;

    public SampleIdentifierPredicate() {
        this(true, false);
    }

    public SampleIdentifierPredicate(boolean isReadAccess) {
        this(isReadAccess, false);
    }

    public SampleIdentifierPredicate(boolean isReadAccess, boolean okForNonExistentSpaces) {
        this.spacePredicate = new SpaceIdentifierPredicate(okForNonExistentSpaces);
        this.databaseInstanceIdentifierPredicate = new DatabaseInstanceIdentifierPredicate(isReadAccess);
    }

    @Override
    public final void init(IAuthorizationDataProvider provider) {
        assert (!this.initialized);
        this.dataProvider = provider;
        this.spacePredicate.init(provider);
        this.databaseInstanceIdentifierPredicate.init(provider);
        this.initialized = true;
    }

    @Override
    public final String getCandidateDescription() {
        return "sample identifier";
    }

    @Override
    protected final Status doEvaluation(PersonPE person, List<RoleWithIdentifier> allowedRoles, SampleIdentifier value) {
        if (SampleIdentifierPredicate.hasInstanceWritePermissions(person, allowedRoles).isOK()) {
            return Status.OK;
        }
        if (value.isProjectLevel()) {
            Status projectResult;
            Status spaceResult = this.spacePredicate.doEvaluation(person, allowedRoles, value.getSpaceLevel());
            if (spaceResult.isError() && (projectResult = this.doEvaluationOfProject(person, allowedRoles, value)).isOK()) {
                return Status.OK;
            }
            return spaceResult;
        }
        if (value.isSpaceLevel()) {
            Status projectResult;
            Status spaceResult = this.spacePredicate.doEvaluation(person, allowedRoles, value.getSpaceLevel());
            if (spaceResult.isError() && (projectResult = this.doEvaluationOfExperimentProject(person, allowedRoles, value)).isOK()) {
                return Status.OK;
            }
            return spaceResult;
        }
        if (value.isDatabaseInstanceLevel()) {
            return this.databaseInstanceIdentifierPredicate.doEvaluation(person, allowedRoles, null);
        }
        throw new RuntimeException("Unsupported sample identifier '" + value.toString() + "'");
    }

    protected Status doEvaluationOfProject(PersonPE person, List<RoleWithIdentifier> allowedRoles, SampleIdentifier value) {
        IProjectAuthorization<ProjectIdentifier> pa = new ProjectAuthorizationBuilder().withData(this.dataProvider).withUser(new UserProviderFromPersonPE(person)).withRoles(new RolesProviderFromRolesWithIdentifier(allowedRoles)).withObjects(new ProjectProviderFromProjectIdentifierObject(value.getProjectLevel())).build();
        if (pa.getObjectsWithoutAccess().isEmpty()) {
            return Status.OK;
        }
        return Status.createError();
    }

    protected Status doEvaluationOfExperimentProject(PersonPE person, List<RoleWithIdentifier> allowedRoles, SampleIdentifier value) {
        String spaceCode = SpaceCodeHelper.getSpaceCode(person, value.getSpaceLevel());
        String sampleCode = value.getSampleCode();
        if (sampleCode == null) {
            return Status.createError();
        }
        IProjectAuthorization<ProjectProviderFromSpaceCodeAndSampleCode.SpaceCodeAndSampleCode> pa = new ProjectAuthorizationBuilder().withData(this.dataProvider).withUser(new UserProviderFromPersonPE(person)).withRoles(new RolesProviderFromRolesWithIdentifier(allowedRoles)).withObjects(new ProjectProviderFromSpaceCodeAndSampleCode(spaceCode, sampleCode)).build();
        if (pa.getObjectsWithoutAccess().isEmpty()) {
            return Status.OK;
        }
        return Status.createError();
    }
}

