/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.authorization.predicate;

import ch.systemsx.cisd.common.db.mapper.LongArrayMapper;
import ch.systemsx.cisd.common.db.mapper.StringArrayMapper;
import ch.systemsx.cisd.common.exceptions.AuthorizationFailureException;
import ch.systemsx.cisd.common.exceptions.Status;
import ch.systemsx.cisd.openbis.generic.server.authorization.IAuthorizationDataProvider;
import ch.systemsx.cisd.openbis.generic.server.authorization.RoleWithIdentifier;
import ch.systemsx.cisd.openbis.generic.server.authorization.annotation.ShouldFlattenCollections;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.AbstractSpacePredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.SampleIdentifierPredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.project.IProjectAuthorization;
import ch.systemsx.cisd.openbis.generic.server.authorization.project.ProjectAuthorizationBuilder;
import ch.systemsx.cisd.openbis.generic.server.authorization.project.provider.project.ProjectsProviderFromSampleV1Collection;
import ch.systemsx.cisd.openbis.generic.server.authorization.project.provider.role.RolesProviderFromRolesWithIdentifier;
import ch.systemsx.cisd.openbis.generic.server.authorization.project.provider.user.UserProviderFromPersonPE;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.Sample;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleIdentifierFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import net.lemnik.eodsql.BaseQuery;
import net.lemnik.eodsql.QueryTool;
import net.lemnik.eodsql.Select;

@ShouldFlattenCollections(value=false)
public class SampleListPredicate
extends AbstractSpacePredicate<List<Sample>> {
    private static final int ARRAY_SIZE_LIMIT = 999;
    private final SampleIdentifierPredicate sampleIdentifierPredicate = new SampleIdentifierPredicate();
    private final ISampleToSpaceQuery sampleToSpaceQuery = (ISampleToSpaceQuery)QueryTool.getManagedQuery(ISampleToSpaceQuery.class);

    @Override
    public final void init(IAuthorizationDataProvider provider) {
        super.init(provider);
        this.sampleIdentifierPredicate.init(provider);
    }

    @Override
    public String getCandidateDescription() {
        return "sample";
    }

    @Override
    protected Status doEvaluation(PersonPE person, List<RoleWithIdentifier> allowedRoles, List<Sample> samples) {
        Status status;
        IProjectAuthorization<Sample> pa = new ProjectAuthorizationBuilder().withData(this.authorizationDataProvider).withUser(new UserProviderFromPersonPE(person)).withRoles(new RolesProviderFromRolesWithIdentifier(allowedRoles)).withObjects(new ProjectsProviderFromSampleV1Collection(samples)).build();
        if (pa.getObjectsWithoutAccess().isEmpty()) {
            return Status.OK;
        }
        Collection<Sample> remainingSamples = pa.getObjectsWithoutAccess();
        ArrayList<Long> ids = new ArrayList<Long>(remainingSamples.size());
        ArrayList<String> permIds = new ArrayList<String>(remainingSamples.size());
        for (Sample sample : remainingSamples) {
            if (sample.getId() == null) {
                throw new AuthorizationFailureException("id is undefined.");
            }
            ids.add(sample.getId());
            if (sample.getPermId() == null) {
                throw new AuthorizationFailureException("permId is undefined.");
            }
            permIds.add(sample.getPermId());
            if (sample.getSpaceCode() != null && !Status.OK.equals((Object)(status = this.evaluate(allowedRoles, person, sample.getSpaceCode())))) {
                return status;
            }
            SampleIdentifier sampleIdentifier = SampleIdentifierFactory.parse(sample.getIdentifier());
            Status status2 = this.sampleIdentifierPredicate.evaluate(person, allowedRoles, sampleIdentifier);
            if (Status.OK.equals((Object)status2)) continue;
            return status2;
        }
        for (String spaceCode : this.getSampleSpaceCodes(ids, permIds)) {
            if (spaceCode == null || Status.OK.equals((Object)(status = this.evaluate(allowedRoles, person, spaceCode)))) continue;
            return status;
        }
        return Status.OK;
    }

    private Collection<String> getSampleSpaceCodes(List<Long> ids, List<String> permIds) {
        if (ids.size() != permIds.size()) {
            throw new IllegalArgumentException("Expect to get the same number of ids and permIds.");
        }
        int size = ids.size();
        if (size == 0) {
            return Collections.emptyList();
        }
        if (size > 999) {
            HashSet<String> spaceCodes = new HashSet<String>(size);
            for (int startIdx = 0; startIdx < size; startIdx += 999) {
                List<Long> idSubList = ids.subList(startIdx, Math.min(size, startIdx + 999));
                List<String> permIdSubList = permIds.subList(startIdx, Math.min(size, startIdx + 999));
                spaceCodes.addAll(this.sampleToSpaceQuery.getSampleSpaceCodes(this.toArray(idSubList), permIdSubList.toArray(new String[permIdSubList.size()])));
            }
            return spaceCodes;
        }
        return this.sampleToSpaceQuery.getSampleSpaceCodes(this.toArray(ids), permIds.toArray(new String[size]));
    }

    private long[] toArray(List<Long> list) {
        long[] result = new long[list.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = list.get(i);
        }
        return result;
    }

    public static interface ISampleToSpaceQuery
    extends BaseQuery {
        @Select(sql="select distinct sp.code from samples sa inner join spaces sp on sa.space_id = sp.id where sa.id = any(?{1}) union select distinct sp.code from samples sa inner join spaces sp on sa.space_id = sp.id where sa.perm_id = any(?{2})", parameterBindings={LongArrayMapper.class, StringArrayMapper.class})
        public List<String> getSampleSpaceCodes(long[] var1, String[] var2);
    }
}

