/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.authorization.predicate;

import ch.systemsx.cisd.common.exceptions.Status;
import ch.systemsx.cisd.openbis.generic.server.authorization.IAuthorizationDataProvider;
import ch.systemsx.cisd.openbis.generic.server.authorization.RoleWithIdentifier;
import ch.systemsx.cisd.openbis.generic.server.authorization.annotation.ShouldFlattenCollections;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.AbstractPredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.DatabaseInstanceIdentifierPredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.SpaceIdentifierPredicate;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleOwnerIdentifier;
import java.util.List;

@ShouldFlattenCollections(value=false)
public final class SampleOwnerIdentifierCollectionPredicate
extends AbstractPredicate<List<SampleOwnerIdentifier>> {
    private final SpaceIdentifierPredicate spacePredicate = new SpaceIdentifierPredicate();
    private final DatabaseInstanceIdentifierPredicate databaseInstanceIdentifierPredicate;

    public SampleOwnerIdentifierCollectionPredicate() {
        this(true);
    }

    public SampleOwnerIdentifierCollectionPredicate(boolean isReadAccess) {
        this.databaseInstanceIdentifierPredicate = new DatabaseInstanceIdentifierPredicate(isReadAccess);
    }

    @Override
    public final void init(IAuthorizationDataProvider provider) {
        this.spacePredicate.init(provider);
        this.databaseInstanceIdentifierPredicate.init(provider);
    }

    @Override
    public final String getCandidateDescription() {
        return "sample identifier";
    }

    @Override
    protected final Status doEvaluation(PersonPE person, List<RoleWithIdentifier> allowedRoles, List<SampleOwnerIdentifier> values) {
        for (SampleOwnerIdentifier value : values) {
            Status result;
            if (!(value.isDatabaseInstanceLevel() ? Status.OK != (result = this.databaseInstanceIdentifierPredicate.doEvaluation(person, allowedRoles, null)) : Status.OK != (result = this.spacePredicate.doEvaluation(person, allowedRoles, value.getSpaceLevel())))) continue;
            return result;
        }
        return Status.OK;
    }
}

