/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.authorization.predicate;

import ch.systemsx.cisd.common.exceptions.Status;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.generic.server.authorization.RoleWithIdentifier;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.PersistentEntityPredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.project.IProjectAuthorization;
import ch.systemsx.cisd.openbis.generic.server.authorization.project.ProjectAuthorizationBuilder;
import ch.systemsx.cisd.openbis.generic.server.authorization.project.provider.project.ProjectProviderFromProjectPE;
import ch.systemsx.cisd.openbis.generic.server.authorization.project.provider.role.RolesProviderFromRolesWithIdentifier;
import ch.systemsx.cisd.openbis.generic.server.authorization.project.provider.user.UserProviderFromPersonPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ProjectPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SamplePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SpacePE;
import java.util.List;

public class SamplePEPredicate
extends PersistentEntityPredicate<SamplePE> {
    public SamplePEPredicate() {
    }

    public SamplePEPredicate(boolean isReadAccess) {
        super(isReadAccess);
    }

    @Override
    public Status evaluate(PersonPE person, List<RoleWithIdentifier> allowedRoles, SamplePE value) throws UserFailureException {
        Status result = super.evaluate(person, allowedRoles, value);
        if (result.isOK()) {
            return Status.OK;
        }
        if (value != null) {
            IProjectAuthorization<ProjectPE> pa;
            ProjectPE project;
            ProjectPE projectPE = project = value.getExperiment() != null ? value.getExperiment().getProject() : value.getProject();
            if (project != null && (pa = new ProjectAuthorizationBuilder().withData(this.provider).withUser(new UserProviderFromPersonPE(person)).withRoles(new RolesProviderFromRolesWithIdentifier(allowedRoles)).withObjects(new ProjectProviderFromProjectPE(project)).build()).getObjectsWithoutAccess().isEmpty()) {
                return Status.OK;
            }
        }
        return result;
    }

    @Override
    public SpacePE getSpace(SamplePE sample) {
        return sample == null ? null : sample.getSpace();
    }
}

