/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.authorization.predicate;

import ch.systemsx.cisd.common.exceptions.Status;
import ch.systemsx.cisd.openbis.generic.server.authorization.IAuthorizationDataProvider;
import ch.systemsx.cisd.openbis.generic.server.authorization.RoleWithIdentifier;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.AbstractDatabaseInstancePredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.SamplePEPredicate;
import ch.systemsx.cisd.openbis.generic.shared.dto.PermId;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SamplePE;
import java.util.List;

public class SamplePermIdPredicate
extends AbstractDatabaseInstancePredicate<PermId> {
    private final SamplePEPredicate samplePEPredicate;
    private final boolean nullAllowed;

    public SamplePermIdPredicate() {
        this(true, false);
    }

    public SamplePermIdPredicate(boolean isReadAccess, boolean nullAllowed) {
        this.nullAllowed = nullAllowed;
        this.samplePEPredicate = new SamplePEPredicate(isReadAccess);
    }

    @Override
    public final void init(IAuthorizationDataProvider provider) {
        super.init(provider);
        this.samplePEPredicate.init(provider);
    }

    @Override
    public final String getCandidateDescription() {
        return "sample perm id";
    }

    @Override
    protected final Status doEvaluation(PersonPE person, List<RoleWithIdentifier> allowedRoles, PermId id) {
        SamplePE sample = this.authorizationDataProvider.tryGetSampleByPermId(id.getId());
        if (sample == null) {
            return this.nullAllowed ? Status.OK : Status.createError((String)String.format("There is no sample with perm id '%s'.", id.getId()));
        }
        return this.samplePEPredicate.evaluate(person, allowedRoles, sample);
    }
}

