/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.authorization.predicate;

import ch.systemsx.cisd.common.exceptions.Status;
import ch.systemsx.cisd.openbis.generic.server.authorization.IAuthorizationDataProvider;
import ch.systemsx.cisd.openbis.generic.server.authorization.RoleWithIdentifier;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.AbstractDatabaseInstancePredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.SampleAccessPECollectionPredicate;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SampleAccessPE;
import java.util.Arrays;
import java.util.List;
import java.util.Set;

public class SampleTechIdPredicate
extends AbstractDatabaseInstancePredicate<TechId> {
    private final SampleAccessPECollectionPredicate sampleAccessPECollectionPredicate;

    public SampleTechIdPredicate() {
        this(true);
    }

    public SampleTechIdPredicate(boolean isReadAccess) {
        this.sampleAccessPECollectionPredicate = new SampleAccessPECollectionPredicate(isReadAccess);
    }

    @Override
    public final void init(IAuthorizationDataProvider provider) {
        super.init(provider);
        this.sampleAccessPECollectionPredicate.init(provider);
    }

    @Override
    public final String getCandidateDescription() {
        return "sample technical id";
    }

    @Override
    protected final Status doEvaluation(PersonPE person, List<RoleWithIdentifier> allowedRoles, TechId techId) {
        Set<SampleAccessPE> samples = this.authorizationDataProvider.getSampleCollectionAccessDataByTechIds(techId != null ? Arrays.asList(techId) : Arrays.asList(new TechId[0]), true);
        return this.sampleAccessPECollectionPredicate.doEvaluation(person, allowedRoles, samples);
    }
}

