/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.authorization.predicate;

import ch.systemsx.cisd.common.exceptions.Status;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.common.conversation.context.ServiceConversationsThreadContext;
import ch.systemsx.cisd.openbis.common.conversation.progress.IServiceConversationProgressListener;
import ch.systemsx.cisd.openbis.generic.server.authorization.IAuthorizationDataProvider;
import ch.systemsx.cisd.openbis.generic.server.authorization.RoleWithIdentifier;
import ch.systemsx.cisd.openbis.generic.server.authorization.annotation.ShouldFlattenCollections;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.AbstractPredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.ProjectIdentifierPredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.SampleIdentifierCollectionPredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.SampleTechIdCollectionPredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.SampleUpdatesPredicate;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SampleUpdatesDTO;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleIdentifierFactory;
import java.util.ArrayList;
import java.util.List;

@ShouldFlattenCollections(value=false)
public class SampleUpdatesCollectionPredicate
extends AbstractPredicate<List<SampleUpdatesDTO>> {
    private final ProjectIdentifierPredicate projectIdentifierPredicate = new ProjectIdentifierPredicate();
    private final SampleTechIdCollectionPredicate sampleTechIdCollectionPredicate = new SampleTechIdCollectionPredicate(false);
    private final SampleIdentifierCollectionPredicate sampleIdentifierCollectionPredicate = new SampleIdentifierCollectionPredicate(false);

    @Override
    public void init(IAuthorizationDataProvider provider) {
        this.projectIdentifierPredicate.init(provider);
        this.sampleTechIdCollectionPredicate.init(provider);
        this.sampleIdentifierCollectionPredicate.init(provider);
    }

    @Override
    public String getCandidateDescription() {
        return "sample updates collection";
    }

    @Override
    protected Status doEvaluation(PersonPE person, List<RoleWithIdentifier> allowedRoles, List<SampleUpdatesDTO> value) {
        if (SampleUpdatesCollectionPredicate.hasInstanceWritePermissions(person, allowedRoles).isOK()) {
            return Status.OK;
        }
        IServiceConversationProgressListener progressListener = ServiceConversationsThreadContext.getProgressListener();
        ArrayList<TechId> techIds = new ArrayList<TechId>(value.size());
        ArrayList<SampleIdentifier> containerIdentifiers = new ArrayList<SampleIdentifier>();
        int index = 0;
        for (SampleUpdatesDTO sampleUpdates : value) {
            Status result;
            if (sampleUpdates == null) {
                throw UserFailureException.fromTemplate((String)"No sample updates specified.", (Object[])new Object[0]);
            }
            TechId sampleId = sampleUpdates.getSampleIdOrNull();
            if (sampleId != null) {
                techIds.add(sampleId);
            }
            if (!(result = SampleUpdatesPredicate.evaluateBasedOnExperimentOrProject(this.projectIdentifierPredicate, person, allowedRoles, sampleUpdates)).isOK()) {
                return result;
            }
            if (sampleUpdates.getContainerIdentifierOrNull() != null) {
                SampleIdentifier containerIdentifier = SampleIdentifierFactory.parse(sampleUpdates.getContainerIdentifierOrNull());
                containerIdentifiers.add(containerIdentifier);
            }
            progressListener.update("authorizeSampleUpdates", value.size(), ++index);
        }
        Status result = this.sampleTechIdCollectionPredicate.doEvaluation(person, allowedRoles, techIds);
        if (!result.isOK()) {
            return result;
        }
        if (!containerIdentifiers.isEmpty() && !(result = this.sampleIdentifierCollectionPredicate.doEvaluation(person, allowedRoles, containerIdentifiers)).isOK()) {
            return result;
        }
        return result;
    }
}

