/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.authorization.predicate;

import ch.systemsx.cisd.common.exceptions.Status;
import ch.systemsx.cisd.openbis.generic.server.authorization.IAuthorizationDataProvider;
import ch.systemsx.cisd.openbis.generic.server.authorization.RoleWithIdentifier;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.AbstractSamplePredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.ProjectIdentifierPredicate;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SampleUpdatesDTO;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ExperimentIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ProjectIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleIdentifierFactory;
import java.util.List;

public class SampleUpdatesPredicate
extends AbstractSamplePredicate<SampleUpdatesDTO> {
    private ProjectIdentifierPredicate projectIdentifierPredicate = new ProjectIdentifierPredicate();

    public SampleUpdatesPredicate() {
        super(false);
    }

    @Override
    public void init(IAuthorizationDataProvider provider) {
        super.init(provider);
        this.projectIdentifierPredicate.init(provider);
    }

    @Override
    public final String getCandidateDescription() {
        return "sample updates";
    }

    @Override
    protected Status doEvaluation(PersonPE person, List<RoleWithIdentifier> allowedRoles, SampleUpdatesDTO updates) {
        SampleIdentifier containerIdentifier;
        Status status;
        assert (this.sampleTechIdPredicate.initialized) : "Predicate has not been initialized";
        assert (this.projectIdentifierPredicate.initialized) : "Predicate has not been initialized";
        assert (this.sampleIdentifierPredicate.initialized) : "Predicate has not been initialized";
        if (updates.getSampleIdOrNull() != null && !(status = this.sampleTechIdPredicate.doEvaluation(person, allowedRoles, updates.getSampleIdOrNull())).equals((Object)Status.OK)) {
            return status;
        }
        status = SampleUpdatesPredicate.evaluateBasedOnExperimentOrProject(this.projectIdentifierPredicate, person, allowedRoles, updates);
        if (!status.isOK()) {
            return status;
        }
        if (updates.getContainerIdentifierOrNull() != null && !(status = this.sampleIdentifierPredicate.doEvaluation(person, allowedRoles, containerIdentifier = SampleIdentifierFactory.parse(updates.getContainerIdentifierOrNull()))).equals((Object)Status.OK)) {
            return status;
        }
        return status;
    }

    static Status evaluateBasedOnExperimentOrProject(ProjectIdentifierPredicate projectIdentifierPredicate, PersonPE person, List<RoleWithIdentifier> allowedRoles, SampleUpdatesDTO sampleUpdates) {
        Status result;
        ExperimentIdentifier expId = sampleUpdates.getExperimentIdentifierOrNull();
        if (expId != null && !(result = projectIdentifierPredicate.doEvaluation(person, allowedRoles, expId)).isOK()) {
            return result;
        }
        ProjectIdentifier projId = sampleUpdates.getProjectIdentifier();
        if (projId != null) {
            return projectIdentifierPredicate.doEvaluation(person, allowedRoles, projId);
        }
        return Status.OK;
    }
}

