/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.authorization.predicate;

import ch.systemsx.cisd.common.exceptions.Status;
import ch.systemsx.cisd.openbis.generic.server.authorization.IAuthorizationDataProvider;
import ch.systemsx.cisd.openbis.generic.server.authorization.RoleWithIdentifier;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.AbstractSpacePredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.ProjectPEPredicate;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ProjectPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SpacePE;
import java.util.Iterator;
import java.util.List;

public class SpaceOrProjectPredicate
extends AbstractSpacePredicate<String> {
    private ProjectPEPredicate projectPEPredicate = new ProjectPEPredicate();

    public SpaceOrProjectPredicate(boolean okForNonExistentSpaces) {
        super(okForNonExistentSpaces);
    }

    @Override
    public void init(IAuthorizationDataProvider dataProvider) {
        super.init(dataProvider);
        this.projectPEPredicate.init(dataProvider);
    }

    @Override
    protected boolean isNullValueAllowed() {
        return true;
    }

    @Override
    protected Status doEvaluation(PersonPE person, List<RoleWithIdentifier> allowedRoles, String valueOrNull) {
        Status status;
        block2: {
            ProjectPE project;
            SpacePE space;
            if (SpaceOrProjectPredicate.hasInstanceWritePermissions(person, allowedRoles).isOK()) {
                return Status.OK;
            }
            status = this.evaluate(allowedRoles, person, valueOrNull);
            if (!status.isError() || valueOrNull == null || (space = this.authorizationDataProvider.tryGetSpace(valueOrNull)) == null) break block2;
            Iterator<ProjectPE> iterator = space.getProjects().iterator();
            while (iterator.hasNext() && !(status = this.projectPEPredicate.evaluate(person, allowedRoles, project = iterator.next())).isOK()) {
            }
        }
        return status;
    }

    @Override
    public String getCandidateDescription() {
        return "space";
    }
}

