/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.authorization.predicate;

import ch.systemsx.cisd.common.exceptions.Status;
import ch.systemsx.cisd.openbis.generic.server.authorization.IAuthorizationDataProvider;
import ch.systemsx.cisd.openbis.generic.server.authorization.RoleWithIdentifier;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.AbstractPredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.IPredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.ProjectIdentifierPredicate;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewBasicExperiment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.UpdatedExperimentsWithType;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ExperimentIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ExperimentIdentifierFactory;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ProjectIdentifier;
import java.util.List;

public final class UpdatedExperimentsWithTypePredicate
extends AbstractPredicate<UpdatedExperimentsWithType> {
    private final IPredicate<ProjectIdentifier> delegate;

    @Override
    public final void init(IAuthorizationDataProvider provider) {
        this.delegate.init(provider);
    }

    @Override
    public final Status doEvaluation(PersonPE person, List<RoleWithIdentifier> allowedRoles, UpdatedExperimentsWithType value) {
        Status s = Status.OK;
        for (NewBasicExperiment newBasicExperiment : value.getUpdatedExperiments()) {
            ExperimentIdentifier identifier = new ExperimentIdentifierFactory(newBasicExperiment.getIdentifier()).createIdentifier();
            s = this.delegate.evaluate(person, allowedRoles, identifier);
            if (s.equals((Object)Status.OK)) continue;
            return s;
        }
        return s;
    }

    @Deprecated
    UpdatedExperimentsWithTypePredicate(IPredicate<ProjectIdentifier> delegate) {
        this.delegate = delegate;
    }

    public UpdatedExperimentsWithTypePredicate() {
        this.delegate = new ProjectIdentifierPredicate();
    }

    @Override
    public final String getCandidateDescription() {
        return "new experiments with type";
    }
}

