/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.authorization.project;

import ch.systemsx.cisd.openbis.generic.server.authorization.IAuthorizationDataProvider;
import ch.systemsx.cisd.openbis.generic.server.authorization.project.IProjectAuthorization;
import ch.systemsx.cisd.openbis.generic.server.authorization.project.ProjectAuthorizationDisabled;
import ch.systemsx.cisd.openbis.generic.server.authorization.project.ProjectAuthorizationEnabled;
import ch.systemsx.cisd.openbis.generic.server.authorization.project.provider.object.IObjectsProvider;
import ch.systemsx.cisd.openbis.generic.server.authorization.project.provider.role.IRolesProvider;
import ch.systemsx.cisd.openbis.generic.server.authorization.project.provider.user.IUserProvider;
import ch.systemsx.cisd.openbis.generic.shared.authorization.AuthorizationConfigFacade;

public class ProjectAuthorizationBuilder<O> {
    private IAuthorizationDataProvider dataProvider;
    private IUserProvider userProvider;
    private IRolesProvider rolesProvider;
    private IObjectsProvider<O> objectsProvider;

    public ProjectAuthorizationBuilder<O> withData(IAuthorizationDataProvider provider) {
        this.dataProvider = provider;
        return this;
    }

    public ProjectAuthorizationBuilder<O> withUser(IUserProvider provider) {
        this.userProvider = provider;
        return this;
    }

    public ProjectAuthorizationBuilder<O> withRoles(IRolesProvider provider) {
        this.rolesProvider = provider;
        return this;
    }

    public ProjectAuthorizationBuilder<O> withObjects(IObjectsProvider<O> provider) {
        this.objectsProvider = provider;
        return this;
    }

    public IProjectAuthorization<O> build() {
        if (this.dataProvider == null) {
            throw new IllegalArgumentException("Data provider cannot be null");
        }
        if (this.userProvider == null) {
            throw new IllegalArgumentException("User provider cannot be null");
        }
        if (this.rolesProvider == null) {
            throw new IllegalArgumentException("Roles provider cannot be null");
        }
        if (this.objectsProvider == null) {
            throw new IllegalArgumentException("Objects provider cannot be null");
        }
        AuthorizationConfigFacade configFacade = new AuthorizationConfigFacade(this.dataProvider.getAuthorizationConfig());
        if (configFacade.isProjectLevelEnabled(this.userProvider.getUserId())) {
            return new ProjectAuthorizationEnabled<O>(this.dataProvider, this.rolesProvider, this.objectsProvider);
        }
        return new ProjectAuthorizationDisabled<O>(this.objectsProvider);
    }
}

