/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.authorization.project;

import ch.systemsx.cisd.openbis.generic.server.authorization.IAuthorizationDataProvider;
import ch.systemsx.cisd.openbis.generic.server.authorization.project.IProjectAuthorization;
import ch.systemsx.cisd.openbis.generic.server.authorization.project.data.object.IObject;
import ch.systemsx.cisd.openbis.generic.server.authorization.project.data.project.IProject;
import ch.systemsx.cisd.openbis.generic.server.authorization.project.data.role.IRole;
import ch.systemsx.cisd.openbis.generic.server.authorization.project.provider.object.IObjectsProvider;
import ch.systemsx.cisd.openbis.generic.server.authorization.project.provider.role.IRolesProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public class ProjectAuthorizationEnabled<O>
implements IProjectAuthorization<O> {
    private IAuthorizationDataProvider dataProvider;
    private IRolesProvider rolesProvider;
    private IObjectsProvider<O> objectsProvider;
    private Collection<IObject<O>> objectsWithAccess;
    private Collection<IObject<O>> objectsWithoutAccess;
    private boolean initialized;

    ProjectAuthorizationEnabled(IAuthorizationDataProvider dataProvider, IRolesProvider rolesProvider, IObjectsProvider<O> objectsProvider) {
        this.dataProvider = dataProvider;
        this.rolesProvider = rolesProvider;
        this.objectsProvider = objectsProvider;
    }

    @Override
    public Collection<O> getObjectsWithAccess() {
        this.init();
        ArrayList<O> results = new ArrayList<O>();
        for (IObject<O> objectWithAccess : this.objectsWithAccess) {
            results.add(objectWithAccess.getOriginalObject());
        }
        return results;
    }

    @Override
    public Collection<O> getObjectsWithoutAccess() {
        this.init();
        ArrayList<O> results = new ArrayList<O>();
        for (IObject<O> objectWithoutAccess : this.objectsWithoutAccess) {
            results.add(objectWithoutAccess.getOriginalObject());
        }
        return results;
    }

    private void init() {
        ArrayList<IObject<O>> projectObjects;
        Collection<IRole> roles;
        if (this.initialized) {
            return;
        }
        this.objectsWithAccess = new ArrayList<IObject<O>>();
        this.objectsWithoutAccess = new ArrayList<IObject<O>>();
        Collection<IObject<O>> objects = this.objectsProvider.getObjects(this.dataProvider);
        if (objects == null) {
            objects = Collections.emptyList();
        }
        if ((roles = this.rolesProvider.getRoles(this.dataProvider)) == null) {
            roles = Collections.emptyList();
        }
        LinkedHashMap<ProjectKey, ArrayList<IObject<O>>> projectToObjectsMap = new LinkedHashMap<ProjectKey, ArrayList<IObject<O>>>();
        for (IObject<O> iObject : objects) {
            if (iObject.getProject() == null) {
                this.objectsWithoutAccess.add(iObject);
                continue;
            }
            ProjectKey projectKey = new ProjectKey(iObject.getProject());
            projectObjects = (ArrayList<IObject<O>>)projectToObjectsMap.get(projectKey);
            if (projectObjects == null) {
                projectObjects = new ArrayList<IObject<O>>();
                projectToObjectsMap.put(projectKey, projectObjects);
            }
            projectObjects.add(iObject);
        }
        for (Map.Entry entry : projectToObjectsMap.entrySet()) {
            IProject project = ((ProjectKey)entry.getKey()).getProject();
            projectObjects = (Collection)entry.getValue();
            if (this.hasAccess(roles, project)) {
                this.objectsWithAccess.addAll(projectObjects);
                continue;
            }
            this.objectsWithoutAccess.addAll(projectObjects);
        }
        this.initialized = true;
    }

    private boolean hasAccess(Collection<IRole> roles, IProject project) {
        for (IRole role : roles) {
            if (!this.hasAccess(role, project)) continue;
            return true;
        }
        return false;
    }

    private boolean hasAccess(IRole role, IProject project) {
        IProject roleProject = role.getProject();
        if (roleProject == null) {
            return false;
        }
        boolean idNN = ProjectAuthorizationEnabled.areNotNull(project.getId(), roleProject.getId());
        boolean permIdNN = ProjectAuthorizationEnabled.areNotNull(project.getPermId(), roleProject.getPermId());
        boolean identifierNN = ProjectAuthorizationEnabled.areNotNull(project.getIdentifier(), roleProject.getIdentifier());
        boolean idEqual = ProjectAuthorizationEnabled.areEqual(project.getId(), roleProject.getId());
        boolean permIdEqual = ProjectAuthorizationEnabled.areEqual(project.getPermId(), roleProject.getPermId());
        boolean identifierEqual = ProjectAuthorizationEnabled.areEqual(project.getIdentifier(), roleProject.getIdentifier());
        if (idNN && permIdNN) {
            return idEqual && permIdEqual;
        }
        if (idNN) {
            return idEqual;
        }
        if (permIdNN) {
            return permIdEqual;
        }
        if (identifierNN) {
            return identifierEqual;
        }
        return false;
    }

    private static boolean areEqual(Object o1, Object o2) {
        if (o1 == null) {
            return o2 == null;
        }
        return o1.equals(o2);
    }

    private static boolean areNotNull(Object o1, Object o2) {
        return o1 != null && o2 != null;
    }

    private static class ProjectKey {
        private IProject project;

        public ProjectKey(IProject project) {
            if (project == null) {
                throw new IllegalArgumentException("Project cannot be null");
            }
            this.project = project;
        }

        public IProject getProject() {
            return this.project;
        }

        public int hashCode() {
            Long id = this.project.getId();
            if (id != null) {
                return id.hashCode();
            }
            String permId = this.project.getPermId();
            if (permId != null) {
                return permId.hashCode();
            }
            String identifier = this.project.getIdentifier();
            if (identifier != null) {
                return identifier.hashCode();
            }
            return 0;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ProjectKey other = (ProjectKey)obj;
            return ProjectAuthorizationEnabled.areEqual(this.project.getId(), other.project.getId()) && ProjectAuthorizationEnabled.areEqual(this.project.getPermId(), other.project.getPermId()) && ProjectAuthorizationEnabled.areEqual(this.project.getIdentifier(), other.project.getIdentifier());
        }
    }
}

