/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.authorization.project.provider.project;

import ch.systemsx.cisd.openbis.generic.server.authorization.IAuthorizationDataProvider;
import ch.systemsx.cisd.openbis.generic.server.authorization.project.data.project.IProject;
import ch.systemsx.cisd.openbis.generic.server.authorization.project.data.project.ProjectFromIdentifier;
import ch.systemsx.cisd.openbis.generic.server.authorization.project.provider.object.SingleObjectProvider;
import ch.systemsx.cisd.openbis.generic.server.authorization.project.provider.project.ProjectProviderFromSpaceCodeAndSampleCode;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleIdentifierFactory;

public class ProjectProviderFromSampleIdentifierString
extends SingleObjectProvider<String> {
    public ProjectProviderFromSampleIdentifierString(String sampleIdentifierString) {
        super(sampleIdentifierString);
    }

    @Override
    protected IProject createProject(IAuthorizationDataProvider dataProvider, String sampleIdentifierString) {
        SampleIdentifier sampleIdentifier = SampleIdentifierFactory.parse(sampleIdentifierString);
        if (sampleIdentifier.getProjectLevel() != null) {
            return new ProjectFromIdentifier(sampleIdentifier.getProjectLevel().toString());
        }
        if (sampleIdentifier.getSpaceLevel() != null && sampleIdentifier.getSampleCode() != null) {
            String spaceCode = sampleIdentifier.getSpaceLevel().getSpaceCode();
            String sampleCode = sampleIdentifier.getSampleCode();
            ProjectProviderFromSpaceCodeAndSampleCode provider = new ProjectProviderFromSpaceCodeAndSampleCode(spaceCode, sampleCode);
            return provider.createProject(dataProvider, new ProjectProviderFromSpaceCodeAndSampleCode.SpaceCodeAndSampleCode(spaceCode, sampleCode));
        }
        return null;
    }
}

