/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.authorization.project.provider.project;

import ch.systemsx.cisd.openbis.generic.server.authorization.IAuthorizationDataProvider;
import ch.systemsx.cisd.openbis.generic.server.authorization.project.data.project.IProject;
import ch.systemsx.cisd.openbis.generic.server.authorization.project.data.project.ProjectFromProjectPE;
import ch.systemsx.cisd.openbis.generic.server.authorization.project.provider.object.SingleObjectProvider;
import ch.systemsx.cisd.openbis.generic.shared.dto.ProjectPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SamplePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SpacePE;

public class ProjectProviderFromSpaceCodeAndSampleCode
extends SingleObjectProvider<SpaceCodeAndSampleCode> {
    public ProjectProviderFromSpaceCodeAndSampleCode(String spaceCode, String sampleCode) {
        super(new SpaceCodeAndSampleCode(spaceCode, sampleCode));
    }

    @Override
    protected IProject createProject(IAuthorizationDataProvider dataProvider, SpaceCodeAndSampleCode spaceCodeAndSampleCode) {
        SamplePE sample;
        SpacePE space = dataProvider.tryGetSpace(spaceCodeAndSampleCode.getSpaceCode());
        if (space != null && (sample = dataProvider.tryGetSampleBySpaceAndCode(space, spaceCodeAndSampleCode.getSampleCode())) != null) {
            ProjectPE project;
            ProjectPE projectPE = project = sample.getExperiment() != null ? sample.getExperiment().getProject() : null;
            if (project != null) {
                return new ProjectFromProjectPE(project);
            }
        }
        return null;
    }

    public static class SpaceCodeAndSampleCode {
        public String spaceCode;
        public String sampleCode;

        public SpaceCodeAndSampleCode(String spaceCode, String sampleCode) {
            this.spaceCode = spaceCode;
            this.sampleCode = sampleCode;
        }

        public String getSpaceCode() {
            return this.spaceCode;
        }

        public String getSampleCode() {
            return this.sampleCode;
        }
    }
}

