/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.authorization.project.provider.project;

import ch.systemsx.cisd.openbis.generic.server.authorization.IAuthorizationDataProvider;
import ch.systemsx.cisd.openbis.generic.server.authorization.project.data.object.IObject;
import ch.systemsx.cisd.openbis.generic.server.authorization.project.data.object.Object;
import ch.systemsx.cisd.openbis.generic.server.authorization.project.data.project.ProjectFromProjectPE;
import ch.systemsx.cisd.openbis.generic.server.authorization.project.provider.object.IObjectsProvider;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.dto.ExperimentPE;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class ProjectsProviderFromExperimentTechIdCollection
implements IObjectsProvider<TechId> {
    private List<TechId> techIds;

    public ProjectsProviderFromExperimentTechIdCollection(List<TechId> techIds) {
        this.techIds = techIds;
    }

    @Override
    public Collection<TechId> getOriginalObjects() {
        return this.techIds;
    }

    @Override
    public Collection<IObject<TechId>> getObjects(IAuthorizationDataProvider dataProvider) {
        ArrayList<IObject<TechId>> objects = new ArrayList<IObject<TechId>>();
        if (this.techIds != null) {
            Map<TechId, ExperimentPE> experimentPEMap = dataProvider.tryGetExperimentsByTechIds(this.techIds);
            for (TechId techId : this.techIds) {
                ExperimentPE experimentPE = experimentPEMap.get(techId);
                ProjectFromProjectPE project = experimentPE != null ? new ProjectFromProjectPE(experimentPE.getProject()) : null;
                objects.add(new Object<TechId>(techId, project));
            }
        }
        return objects;
    }
}

