/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.authorization.project.provider.project;

import ch.systemsx.cisd.openbis.generic.server.authorization.IAuthorizationDataProvider;
import ch.systemsx.cisd.openbis.generic.server.authorization.project.data.object.IObject;
import ch.systemsx.cisd.openbis.generic.server.authorization.project.data.object.Object;
import ch.systemsx.cisd.openbis.generic.server.authorization.project.data.project.ProjectFromProjectPE;
import ch.systemsx.cisd.openbis.generic.server.authorization.project.provider.object.IObjectsProvider;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.Experiment;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.dto.ExperimentPE;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class ProjectsProviderFromExperimentV1Collection
implements IObjectsProvider<Experiment> {
    private List<Experiment> experiments;

    public ProjectsProviderFromExperimentV1Collection(List<Experiment> experiments) {
        this.experiments = experiments;
    }

    @Override
    public Collection<Experiment> getOriginalObjects() {
        return this.experiments;
    }

    @Override
    public Collection<IObject<Experiment>> getObjects(IAuthorizationDataProvider dataProvider) {
        ArrayList<IObject<Experiment>> objects = new ArrayList<IObject<Experiment>>();
        if (this.experiments != null) {
            ArrayList<TechId> techIds = new ArrayList<TechId>();
            for (Experiment experiment : this.experiments) {
                techIds.add(new TechId(experiment.getId()));
            }
            Map<TechId, ExperimentPE> experimentPEMap = dataProvider.tryGetExperimentsByTechIds(techIds);
            for (Experiment experiment : this.experiments) {
                TechId techId = new TechId(experiment.getId());
                ExperimentPE experimentPE = experimentPEMap.get(techId);
                ProjectFromProjectPE project = experimentPE != null ? new ProjectFromProjectPE(experimentPE.getProject()) : null;
                objects.add(new Object<Experiment>(experiment, project));
            }
        }
        return objects;
    }
}

