/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.authorization.project.provider.project;

import ch.systemsx.cisd.openbis.generic.server.authorization.IAuthorizationDataProvider;
import ch.systemsx.cisd.openbis.generic.server.authorization.project.data.object.IObject;
import ch.systemsx.cisd.openbis.generic.server.authorization.project.data.object.Object;
import ch.systemsx.cisd.openbis.generic.server.authorization.project.data.project.ProjectFromProjectPE;
import ch.systemsx.cisd.openbis.generic.server.authorization.project.provider.object.IObjectsProvider;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.dto.ProjectPE;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class ProjectsProviderFromProjectTechIdCollection
implements IObjectsProvider<TechId> {
    private List<TechId> techIds;

    public ProjectsProviderFromProjectTechIdCollection(List<TechId> techIds) {
        this.techIds = techIds;
    }

    @Override
    public Collection<TechId> getOriginalObjects() {
        return this.techIds;
    }

    @Override
    public Collection<IObject<TechId>> getObjects(IAuthorizationDataProvider dataProvider) {
        ArrayList<IObject<TechId>> objects = new ArrayList<IObject<TechId>>();
        if (this.techIds != null) {
            Map<TechId, ProjectPE> projectPEMap = dataProvider.tryGetProjectsByTechIds(this.techIds);
            for (TechId techId : this.techIds) {
                ProjectPE projectPE = projectPEMap.get(techId);
                ProjectFromProjectPE project = projectPE != null ? new ProjectFromProjectPE(projectPE) : null;
                objects.add(new Object<TechId>(techId, project));
            }
        }
        return objects;
    }
}

