/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.authorization.project.provider.project;

import ch.systemsx.cisd.openbis.generic.server.authorization.IAuthorizationDataProvider;
import ch.systemsx.cisd.openbis.generic.server.authorization.project.data.object.IObject;
import ch.systemsx.cisd.openbis.generic.server.authorization.project.data.object.Object;
import ch.systemsx.cisd.openbis.generic.server.authorization.project.data.project.ProjectFromProjectPE;
import ch.systemsx.cisd.openbis.generic.server.authorization.project.provider.object.IObjectsProvider;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.Sample;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.dto.ProjectPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SamplePE;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class ProjectsProviderFromSampleV1Collection
implements IObjectsProvider<Sample> {
    private List<Sample> samples;

    public ProjectsProviderFromSampleV1Collection(List<Sample> samples) {
        this.samples = samples;
    }

    @Override
    public Collection<Sample> getOriginalObjects() {
        return this.samples;
    }

    @Override
    public Collection<IObject<Sample>> getObjects(IAuthorizationDataProvider dataProvider) {
        ArrayList<IObject<Sample>> objects = new ArrayList<IObject<Sample>>();
        if (this.samples != null) {
            ArrayList<TechId> techIds = new ArrayList<TechId>();
            for (Sample sample : this.samples) {
                techIds.add(new TechId(sample.getId()));
            }
            Map<TechId, SamplePE> samplePEMap = dataProvider.tryGetSamplesByTechIds(techIds);
            for (Sample sample : this.samples) {
                TechId techId = new TechId(sample.getId());
                SamplePE samplePE = samplePEMap.get(techId);
                if (samplePE != null) {
                    ProjectPE projectPE = samplePE.getExperiment() != null ? samplePE.getExperiment().getProject() : samplePE.getProject();
                    ProjectFromProjectPE project = projectPE != null ? new ProjectFromProjectPE(projectPE) : null;
                    objects.add(new Object<Sample>(sample, project));
                    continue;
                }
                objects.add(new Object<Sample>(sample, null));
            }
        }
        return objects;
    }
}

