/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.authorization.validator;

import ch.systemsx.cisd.openbis.generic.server.authorization.IAuthorizationDataProvider;
import ch.systemsx.cisd.openbis.generic.server.authorization.validator.AbstractValidator;
import ch.systemsx.cisd.openbis.generic.server.authorization.validator.ExperimentByIdentiferValidator;
import ch.systemsx.cisd.openbis.generic.server.authorization.validator.SampleByIdentiferValidator;
import ch.systemsx.cisd.openbis.generic.shared.basic.IIdentifierHolder;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;

public abstract class AbstractDataSetByExperimentOrSampleIdentifierValidator<DATA_SET>
extends AbstractValidator<DATA_SET> {
    private final ExperimentByIdentiferValidator experimentValidator = new ExperimentByIdentiferValidator();
    private final SampleByIdentiferValidator sampleValidator = new SampleByIdentiferValidator();

    @Override
    public void init(IAuthorizationDataProvider provider) {
        super.init(provider);
        this.experimentValidator.init(provider);
        this.sampleValidator.init(provider);
    }

    @Override
    public boolean doValidation(PersonPE person, final DATA_SET dataSet) {
        if (this.getExperimentIdentifier(dataSet) != null) {
            return this.experimentValidator.isValid(person, new IIdentifierHolder(){

                public String getIdentifier() {
                    return AbstractDataSetByExperimentOrSampleIdentifierValidator.this.getExperimentIdentifier(dataSet);
                }
            });
        }
        return this.sampleValidator.isValid(person, new IIdentifierHolder(){

            public String getIdentifier() {
                return AbstractDataSetByExperimentOrSampleIdentifierValidator.this.getSampleIdentifier(dataSet);
            }
        });
    }

    protected abstract boolean isStorageConfirmed(DATA_SET var1);

    protected abstract String getExperimentIdentifier(DATA_SET var1);

    protected abstract String getSampleIdentifier(DATA_SET var1);
}

