/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.authorization.validator;

import ch.systemsx.cisd.openbis.generic.server.authorization.IAuthorizationDataProvider;
import ch.systemsx.cisd.openbis.generic.server.authorization.project.IProjectAuthorization;
import ch.systemsx.cisd.openbis.generic.server.authorization.project.ProjectAuthorizationBuilder;
import ch.systemsx.cisd.openbis.generic.server.authorization.project.provider.object.IObjectsProvider;
import ch.systemsx.cisd.openbis.generic.server.authorization.project.provider.role.RolesProviderFromPersonPE;
import ch.systemsx.cisd.openbis.generic.server.authorization.project.provider.user.UserProviderFromPersonPE;
import ch.systemsx.cisd.openbis.generic.server.authorization.validator.IValidator;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;

public abstract class AbstractValidator<T>
implements IValidator<T> {
    protected IAuthorizationDataProvider authorizationDataProvider;

    public abstract boolean doValidation(PersonPE var1, T var2);

    @Override
    public final boolean isValid(PersonPE person, T value) {
        assert (person != null) : "Unspecified person";
        assert (value != null) : "Unspecified value";
        return this.doValidation(person, value);
    }

    protected <O> boolean isValidPA(PersonPE person, IObjectsProvider<O> provider) {
        IProjectAuthorization pa = new ProjectAuthorizationBuilder().withData(this.authorizationDataProvider).withUser(new UserProviderFromPersonPE(person)).withRoles(new RolesProviderFromPersonPE(person)).withObjects(provider).build();
        return pa.getObjectsWithoutAccess().isEmpty();
    }

    @Override
    public void init(IAuthorizationDataProvider authorizationDataProvider) {
        this.authorizationDataProvider = authorizationDataProvider;
    }
}

