/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.authorization.validator;

import ch.systemsx.cisd.openbis.generic.server.authorization.validator.AbstractValidator;
import ch.systemsx.cisd.openbis.generic.shared.authorization.AuthorizationConfigFacade;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Deletion;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Person;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.RoleWithHierarchy;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataSetAccessPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ExperimentAccessPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ProjectPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.RoleAssignmentPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SampleAccessPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SpacePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ProjectIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SpaceIdentifier;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public final class DeletionValidator
extends AbstractValidator<Deletion> {
    @Override
    public final boolean doValidation(PersonPE person, Deletion value) {
        return this.isRegistrator(person, value) || DeletionValidator.isInstanceAdmin(person) || this.isSpaceOrProjectAdmin(person, value);
    }

    private boolean isSpaceOrProjectAdmin(PersonPE person, Deletion value) {
        List<TechId> singletonList = Collections.singletonList(new TechId(value.getId()));
        Set<ExperimentAccessPE> experimentAccessData = this.authorizationDataProvider.getDeletedExperimentCollectionAccessData(singletonList);
        for (ExperimentAccessPE experimentAccessPE : experimentAccessData) {
            if (this.verifySpace(person, experimentAccessPE.getSpaceCode())) {
                return true;
            }
            if (experimentAccessPE.getProjectCode() == null || !this.verifyProject(person, experimentAccessPE.getSpaceCode(), experimentAccessPE.getProjectCode())) continue;
            return true;
        }
        Set<SampleAccessPE> samples = this.authorizationDataProvider.getDeletedSampleCollectionAccessData(singletonList);
        for (SampleAccessPE sample : samples) {
            if (sample.getSpaceCode() != null) {
                if (this.verifySpace(person, sample.getSpaceCode())) {
                    return true;
                }
                String projectCode = sample.getProjectCode() != null ? sample.getProjectCode() : sample.getExperimentProjectCode();
                if (projectCode == null || !this.verifyProject(person, sample.getSpaceCode(), projectCode)) continue;
                return true;
            }
            if (!DeletionValidator.isInstanceAdmin(person)) continue;
            return true;
        }
        Set<DataSetAccessPE> set = this.authorizationDataProvider.getDeletedDatasetCollectionAccessData(singletonList);
        for (DataSetAccessPE datasetAccessDatum : set) {
            SpaceIdentifier spaceIdentifier = datasetAccessDatum.getSpaceIdentifier();
            if (spaceIdentifier != null && this.verifySpace(person, spaceIdentifier.getSpaceCode())) {
                return true;
            }
            ProjectIdentifier projectIdentifier = datasetAccessDatum.getProjectIdentifier();
            if (projectIdentifier == null || !this.verifyProject(person, projectIdentifier.getSpaceCode(), projectIdentifier.getProjectCode())) continue;
            return true;
        }
        return false;
    }

    private boolean verifySpace(PersonPE person, String spaceCode) {
        Set<RoleAssignmentPE> roleAssignments = person.getAllPersonRoles();
        for (RoleAssignmentPE roleAssignment : roleAssignments) {
            SpacePE space = roleAssignment.getSpace();
            if (space == null || !roleAssignment.getRole().equals((Object)RoleWithHierarchy.RoleCode.ADMIN) || !space.getCode().equals(spaceCode)) continue;
            return true;
        }
        return false;
    }

    private boolean verifyProject(PersonPE person, String spaceCode, String projectCode) {
        AuthorizationConfigFacade configFacade = new AuthorizationConfigFacade(this.authorizationDataProvider.getAuthorizationConfig());
        if (configFacade.isProjectLevelEnabled(person.getUserId())) {
            Set<RoleAssignmentPE> roleAssignments = person.getAllPersonRoles();
            for (RoleAssignmentPE roleAssignment : roleAssignments) {
                ProjectPE project = roleAssignment.getProject();
                if (project == null || !roleAssignment.getRole().equals((Object)RoleWithHierarchy.RoleCode.ADMIN) || !project.getCode().equals(projectCode) || !project.getSpace().getCode().equals(spaceCode)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isRegistrator(PersonPE person, Deletion value) {
        Person registrator = value.getRegistrator();
        return person.getUserId().equals(registrator.getUserId());
    }

    private static boolean isInstanceAdmin(PersonPE person) {
        Set<RoleAssignmentPE> roleAssignments = person.getAllPersonRoles();
        for (RoleAssignmentPE roleAssignment : roleAssignments) {
            if (!roleAssignment.getRoleWithHierarchy().isInstanceLevel() || !roleAssignment.getRole().equals((Object)RoleWithHierarchy.RoleCode.ADMIN)) continue;
            return true;
        }
        return false;
    }
}

