/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.authorization.validator;

import ch.systemsx.cisd.openbis.generic.server.authorization.IAuthorizationDataProvider;
import ch.systemsx.cisd.openbis.generic.server.authorization.validator.AbstractValidator;
import ch.systemsx.cisd.openbis.generic.server.authorization.validator.ExperimentValidator;
import ch.systemsx.cisd.openbis.generic.server.authorization.validator.ExternalDataValidator;
import ch.systemsx.cisd.openbis.generic.server.authorization.validator.IValidator;
import ch.systemsx.cisd.openbis.generic.server.authorization.validator.ProjectValidator;
import ch.systemsx.cisd.openbis.generic.server.authorization.validator.SampleValidator;
import ch.systemsx.cisd.openbis.generic.server.authorization.validator.SimpleSpaceOrProjectValidator;
import ch.systemsx.cisd.openbis.generic.shared.basic.ICodeHolder;
import ch.systemsx.cisd.openbis.generic.shared.basic.IEntityInformationHolderWithIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AbstractExternalData;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityHistory;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Experiment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Project;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Sample;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;

public final class EntityHistoryValidator
extends AbstractValidator<EntityHistory> {
    private final IValidator<ICodeHolder> spaceValidator = new SimpleSpaceOrProjectValidator();
    private final IValidator<Project> projectValidator = new ProjectValidator();
    private final IValidator<Experiment> experimentValidator = new ExperimentValidator();
    private final IValidator<Sample> sampleValidator = new SampleValidator();
    private final IValidator<AbstractExternalData> dataSetValidator = new ExternalDataValidator();

    @Override
    public void init(IAuthorizationDataProvider provider) {
        super.init(provider);
        this.spaceValidator.init(provider);
        this.projectValidator.init(provider);
        this.experimentValidator.init(provider);
        this.sampleValidator.init(provider);
        this.dataSetValidator.init(provider);
    }

    @Override
    public final boolean doValidation(PersonPE person, EntityHistory value) {
        boolean valid = true;
        if (valid && value.tryGetRelatedSpace() != null) {
            boolean bl = valid = valid && this.spaceValidator.isValid(person, value.tryGetRelatedSpace());
        }
        if (valid && value.tryGetRelatedProject() != null) {
            boolean bl = valid = valid && this.projectValidator.isValid(person, value.tryGetRelatedProject());
        }
        if (valid && value.tryGetRelatedEntity() != null) {
            IEntityInformationHolderWithIdentifier entity = value.tryGetRelatedEntity();
            if (entity instanceof Experiment) {
                valid = valid && this.experimentValidator.isValid(person, (Experiment)entity);
            } else if (entity instanceof Sample) {
                valid = valid && this.sampleValidator.isValid(person, (Sample)entity);
            } else if (entity instanceof AbstractExternalData) {
                valid = valid && this.dataSetValidator.isValid(person, (AbstractExternalData)entity);
            } else {
                throw new IllegalArgumentException("Unsupporeted related entity: " + entity.getClass());
            }
        }
        return valid;
    }
}

