/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.authorization.validator;

import ch.systemsx.cisd.openbis.generic.server.authorization.IAuthorizationDataProvider;
import ch.systemsx.cisd.openbis.generic.server.authorization.validator.AbstractValidator;
import ch.systemsx.cisd.openbis.generic.server.authorization.validator.IValidator;
import ch.systemsx.cisd.openbis.generic.server.authorization.validator.ProjectValidator;
import ch.systemsx.cisd.openbis.generic.server.authorization.validator.SpaceValidator;
import ch.systemsx.cisd.openbis.generic.server.authorization.validator.StorageConfirmedForAdminValidator;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AbstractExternalData;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Project;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Space;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;

public final class ExternalDataValidator
extends AbstractValidator<AbstractExternalData> {
    private final IValidator<Space> spaceValidator = new SpaceValidator();
    private final IValidator<Project> projectValidator = new ProjectValidator();
    private final IValidator<AbstractExternalData> storageConfirmedValidator = new StorageConfirmedForAdminValidator();

    @Override
    public void init(IAuthorizationDataProvider provider) {
        super.init(provider);
        this.spaceValidator.init(provider);
        this.projectValidator.init(provider);
        this.storageConfirmedValidator.init(provider);
    }

    @Override
    public final boolean doValidation(PersonPE person, AbstractExternalData dataSet) {
        return (this.isSpaceValid(person, dataSet) || this.isProjectValid(person, dataSet)) && this.storageConfirmedValidator.isValid(person, dataSet);
    }

    private boolean isSpaceValid(PersonPE person, AbstractExternalData dataSet) {
        return this.spaceValidator.isValid(person, dataSet.getSpace());
    }

    private boolean isProjectValid(PersonPE person, AbstractExternalData dataSet) {
        return dataSet.getProject() != null && this.projectValidator.isValid(person, dataSet.getProject());
    }
}

