/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.authorization.validator;

import ch.systemsx.cisd.openbis.generic.server.authorization.project.IProjectAuthorization;
import ch.systemsx.cisd.openbis.generic.server.authorization.project.ProjectAuthorizationBuilder;
import ch.systemsx.cisd.openbis.generic.server.authorization.project.provider.project.ProjectProviderFromProjectIdentifierObject;
import ch.systemsx.cisd.openbis.generic.server.authorization.project.provider.role.RolesProviderFromPersonPE;
import ch.systemsx.cisd.openbis.generic.server.authorization.project.provider.user.UserProviderFromPersonPE;
import ch.systemsx.cisd.openbis.generic.server.authorization.validator.AbstractCollectionValidator;
import ch.systemsx.cisd.openbis.generic.server.authorization.validator.IValidator;
import ch.systemsx.cisd.openbis.generic.server.authorization.validator.SpaceValidator;
import ch.systemsx.cisd.openbis.generic.shared.authorization.IAuthorizationConfig;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.MatchingEntity;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Space;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataSetAccessPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ExperimentAccessPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.RoleAssignmentPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SampleAccessPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ProjectIdentifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public final class MatchingEntityValidator
extends AbstractCollectionValidator<MatchingEntity> {
    private final IValidator<Space> groupValidator = new SpaceValidator();

    @Override
    public Collection<MatchingEntity> getValid(PersonPE person, Collection<MatchingEntity> entities) {
        if (this.isInstanceUser(person)) {
            return entities;
        }
        Set<String> spacesWithValidProjects = this.getSpacesWithValidProjects(person);
        HashSet<Long> validMaterialIds = new HashSet<Long>();
        HashSet<Long> validExperimentIds = new HashSet<Long>();
        HashSet<Long> validSampleIds = new HashSet<Long>();
        HashSet<Long> validDataSetIds = new HashSet<Long>();
        HashSet<Long> potentiallyValidExperimentIds = new HashSet<Long>();
        HashSet<Long> potentiallyValidSampleIds = new HashSet<Long>();
        HashSet<Long> potentiallyValidDataSetIds = new HashSet<Long>();
        for (MatchingEntity entity : entities) {
            if (entity == null) continue;
            if (entity.tryGetSpace() == null) {
                if (EntityKind.MATERIAL.equals((Object)entity.getEntityKind())) {
                    validMaterialIds.add(entity.getId());
                    continue;
                }
                if (!EntityKind.SAMPLE.equals((Object)entity.getEntityKind())) continue;
                validSampleIds.add(entity.getId());
                continue;
            }
            boolean valid = this.groupValidator.isValid(person, entity.tryGetSpace());
            if (valid) {
                if (EntityKind.EXPERIMENT.equals((Object)entity.getEntityKind())) {
                    validExperimentIds.add(entity.getId());
                    continue;
                }
                if (EntityKind.SAMPLE.equals((Object)entity.getEntityKind())) {
                    validSampleIds.add(entity.getId());
                    continue;
                }
                if (!EntityKind.DATA_SET.equals((Object)entity.getEntityKind())) continue;
                validDataSetIds.add(entity.getId());
                continue;
            }
            boolean potentiallyValid = spacesWithValidProjects.contains(entity.tryGetSpace().getCode());
            if (!potentiallyValid) continue;
            if (EntityKind.EXPERIMENT.equals((Object)entity.getEntityKind())) {
                potentiallyValidExperimentIds.add(entity.getId());
                continue;
            }
            if (EntityKind.SAMPLE.equals((Object)entity.getEntityKind())) {
                potentiallyValidSampleIds.add(entity.getId());
                continue;
            }
            if (!EntityKind.DATA_SET.equals((Object)entity.getEntityKind())) continue;
            potentiallyValidDataSetIds.add(entity.getId());
        }
        IAuthorizationConfig authorizationConfig = this.authorizationDataProvider.getAuthorizationConfig();
        if (authorizationConfig.isProjectLevelEnabled() && authorizationConfig.isProjectLevelUser(person.getUserId())) {
            HashMap<ProjectIdentifier, Boolean> validatedProjects = new HashMap<ProjectIdentifier, Boolean>();
            if (!potentiallyValidExperimentIds.isEmpty()) {
                Set<ExperimentAccessPE> accessDatas = this.authorizationDataProvider.getExperimentCollectionAccessData(TechId.createList(new ArrayList(potentiallyValidExperimentIds)), false);
                for (ExperimentAccessPE experimentAccessPE : accessDatas) {
                    if (!this.isValidProject(person, experimentAccessPE.getProjectIdentifier(), validatedProjects)) continue;
                    validExperimentIds.add(experimentAccessPE.getExperimentId());
                }
            }
            if (!potentiallyValidSampleIds.isEmpty()) {
                Set<SampleAccessPE> accessDatas = this.authorizationDataProvider.getSampleCollectionAccessDataByTechIds(TechId.createList(new ArrayList(potentiallyValidSampleIds)), false);
                for (SampleAccessPE sampleAccessPE : accessDatas) {
                    if (!this.isValidProject(person, sampleAccessPE.getProjectIdentifier(), validatedProjects)) continue;
                    validSampleIds.add(sampleAccessPE.getSampleId());
                }
            }
            if (!potentiallyValidDataSetIds.isEmpty()) {
                Set<DataSetAccessPE> accessDatas = this.authorizationDataProvider.getDatasetCollectionAccessDataByTechIds(TechId.createList(new ArrayList(potentiallyValidDataSetIds)), false);
                for (DataSetAccessPE dataSetAccessPE : accessDatas) {
                    if (!this.isValidProject(person, dataSetAccessPE.getProjectIdentifier(), validatedProjects)) continue;
                    validDataSetIds.add(dataSetAccessPE.getDataSetId());
                }
            }
        }
        ArrayList<MatchingEntity> validEntities = new ArrayList<MatchingEntity>();
        for (MatchingEntity entity : entities) {
            if (entity == null) continue;
            boolean bl = false;
            if (EntityKind.MATERIAL.equals((Object)entity.getEntityKind())) {
                bl = validMaterialIds.contains(entity.getId());
            } else if (EntityKind.EXPERIMENT.equals((Object)entity.getEntityKind())) {
                bl = validExperimentIds.contains(entity.getId());
            } else if (EntityKind.SAMPLE.equals((Object)entity.getEntityKind())) {
                bl = validSampleIds.contains(entity.getId());
            } else if (EntityKind.DATA_SET.equals((Object)entity.getEntityKind())) {
                bl = validDataSetIds.contains(entity.getId());
            }
            if (!bl) continue;
            validEntities.add(entity);
        }
        return validEntities;
    }

    private boolean isInstanceUser(PersonPE person) {
        for (RoleAssignmentPE role : person.getAllPersonRoles()) {
            if (!role.getRoleWithHierarchy().isInstanceLevel()) continue;
            return true;
        }
        return false;
    }

    private Set<String> getSpacesWithValidProjects(PersonPE person) {
        HashSet<String> spaces = new HashSet<String>();
        for (RoleAssignmentPE role : person.getAllPersonRoles()) {
            if (role.getProject() == null) continue;
            spaces.add(role.getProject().getSpace().getCode());
        }
        return spaces;
    }

    private boolean isValidProject(PersonPE person, ProjectIdentifier project, Map<ProjectIdentifier, Boolean> cache) {
        Boolean valid = cache.get(project);
        if (valid != null) {
            return valid;
        }
        if (project == null) {
            valid = false;
        } else {
            IProjectAuthorization<ProjectIdentifier> pa = new ProjectAuthorizationBuilder().withData(this.authorizationDataProvider).withUser(new UserProviderFromPersonPE(person)).withRoles(new RolesProviderFromPersonPE(person)).withObjects(new ProjectProviderFromProjectIdentifierObject(project)).build();
            valid = pa.getObjectsWithoutAccess().isEmpty();
        }
        cache.put(project, valid);
        return valid;
    }
}

