/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.authorization.validator;

import ch.systemsx.cisd.openbis.generic.server.authorization.IAuthorizationDataProvider;
import ch.systemsx.cisd.openbis.generic.server.authorization.validator.AbstractValidator;
import ch.systemsx.cisd.openbis.generic.server.authorization.validator.IValidator;
import ch.systemsx.cisd.openbis.generic.server.authorization.validator.ProjectByIdentiferValidator;
import ch.systemsx.cisd.openbis.generic.server.authorization.validator.SimpleSpaceValidator;
import ch.systemsx.cisd.openbis.generic.shared.authorization.IAuthorizationConfig;
import ch.systemsx.cisd.openbis.generic.shared.basic.ICodeHolder;
import ch.systemsx.cisd.openbis.generic.shared.basic.IIdentifierHolder;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ProjectPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SpacePE;
import java.util.List;

public class SimpleSpaceOrProjectValidator
extends AbstractValidator<ICodeHolder> {
    private final IValidator<ICodeHolder> spaceValidator = new SimpleSpaceValidator();
    private final IValidator<IIdentifierHolder> projectValidator = new ProjectByIdentiferValidator();

    @Override
    public void init(IAuthorizationDataProvider provider) {
        super.init(provider);
        this.spaceValidator.init(provider);
        this.projectValidator.init(provider);
    }

    @Override
    public boolean doValidation(PersonPE person, ICodeHolder space) {
        return this.canAccessSpace(person, space) || this.canAccessAnySpaceProject(person, space);
    }

    private boolean canAccessSpace(PersonPE person, ICodeHolder space) {
        return this.spaceValidator.isValid(person, space);
    }

    private boolean canAccessAnySpaceProject(PersonPE person, ICodeHolder space) {
        SpacePE spacePE;
        IAuthorizationConfig config = this.authorizationDataProvider.getAuthorizationConfig();
        if (config.isProjectLevelEnabled() && config.isProjectLevelUser(person.getUserId()) && (spacePE = this.authorizationDataProvider.tryGetSpace(space.getCode())) != null) {
            List<ProjectPE> projects = spacePE.getProjects();
            for (ProjectPE project : projects) {
                if (!this.projectValidator.isValid(person, project)) continue;
                return true;
            }
        }
        return false;
    }
}

